<?php
defined('BASEPATH') or exit('No direct script access allowed');
require APPPATH . '/libraries/REST_Controller.php';
require APPPATH . '/helpers/jwt_helper.php';
require APPPATH . '/libraries/Paginado.php';

include APPPATH . '/third_party/jwt/JWT.php';
include APPPATH . '/third_party/jwt/BeforeValidException.php';
include APPPATH . '/third_party/jwt/ExpiredException.php';
include APPPATH . '/third_party/jwt/SignatureInvalidException.php';

use Firebase\JWT\JWT;

class Datos11 extends REST_Controller
{


    public function __construct()
    {
        parent::__construct();
        $token = $this->input->get_request_header('Authorization', true);
        $token = Jwt_helper::verificarToken($token);

        if($token["status"] == 'HTTP_UNAUTHORIZED')
        {
             // Devolviendo el mensaje de error con un codigo 401 HTTP_UNAUTHORIZED
             $this->response($token["message"], REST_Controller::HTTP_UNAUTHORIZED);
        }

         $this->load->model('Datos11_model');
    }


 
    public function agregar11_post()
    {
        $post = (array) json_decode($this->post('form'));
        $respuesta = $this->Datos11_model->agregar11($post);
        $this->response($respuesta, $respuesta['status']);
    }


    public function formato11_get()
    {
        $respuesta = $this->Datos11_model->obtener11($this->get());
        $this->response($respuesta, $respuesta['status']);
    }

    public function index_get()
    {
        $respuesta = $this->Datos11_model->obtenerTiposDeclarante();
        $this->response($respuesta["respuesta"], $respuesta["status"]);
    }
    public function tiposrelacion_get()
    {
        $respuesta = $this->Datos11_model->obtenerTiposRelacion();
        $this->response($respuesta["respuesta"], $respuesta["status"]);
    }


    public function formato11_add_get()
    {
        $respuesta = $this->Datos11_model->obtener11_add($this->get());
        $this->response($respuesta, $respuesta['status']);
    }

    public function index_post()
    {
        $respuesta = $this->Datos11_model->obtener_add($this->post('idformato'), $this->post('idmueble'));
        $this->response($respuesta);
    }

    public function agregar11_add_post()
    {
        $post = (array) json_decode($this->post('form'));
        $respuesta = $this->Datos11_model->agregar11_add($post);
        $this->response($respuesta, $respuesta['status']);
    }

    public function baja_add_post()
    {
        $post = (array) json_decode($this->post('form'));
        $respuesta = $this->Datos11_model->bajaInmueble($post);
        $this->response($respuesta, $respuesta['status']);
    }

  
}
