<?php
defined('BASEPATH') or exit('No direct script access allowed');
require APPPATH . '/libraries/REST_Controller.php';
require APPPATH . '/helpers/jwt_helper.php';
require APPPATH . '/libraries/Paginado.php';

include APPPATH . '/third_party/jwt/JWT.php';
include APPPATH . '/third_party/jwt/BeforeValidException.php';
include APPPATH . '/third_party/jwt/ExpiredException.php';
include APPPATH . '/third_party/jwt/SignatureInvalidException.php';

use Firebase\JWT\JWT;

class Datos13 extends REST_Controller
{


    public function __construct()
    {
        parent::__construct();
        $token = $this->input->get_request_header('Authorization', true);
        $token = Jwt_helper::verificarToken($token);

        if($token["status"] == 'HTTP_UNAUTHORIZED')
        {
             // Devolviendo el mensaje de error con un codigo 401 HTTP_UNAUTHORIZED
             $this->response($token["message"], REST_Controller::HTTP_UNAUTHORIZED);
        }

         $this->load->model('Datos13_model');
    }


 
    public function agregar13_post()
    {
        $post = (array) json_decode($this->post('form'));
        $respuesta = $this->Datos13_model->agregar13($post);
        $this->response($respuesta, $respuesta['status']);
    }


    public function formato13_get()
    {
        $respuesta = $this->Datos13_model->obtener13($this->get());
        $this->response($respuesta, $respuesta['status']);
    }

    public function index_get()
    {
        $respuesta = $this->Datos13_model->obtenerTiposDeclarante();
        $this->response($respuesta["respuesta"], $respuesta["status"]);
    }


    public function formato13_add_get()
    {
        $respuesta = $this->Datos13_model->obtener13_add($this->get());
        $this->response($respuesta, $respuesta['status']);
    }

    public function index_post()
    {
        $respuesta = $this->Datos13_model->obtener_add($this->post('idformato'), $this->post('idadeudo'));
        $this->response($respuesta);
    }

    public function agregar13_add_post()
    {
        $post = (array) json_decode($this->post('form'));
        $respuesta = $this->Datos13_model->agregar13_add($post);
        $this->response($respuesta, $respuesta['status']);
    }

    public function baja_add_post()
    {
        $post = (array) json_decode($this->post('form'));
        $respuesta = $this->Datos13_model->bajaAdeudo($post);
        $this->response($respuesta, $respuesta['status']);
    }
  
}
