<?php
defined('BASEPATH') or exit('No direct script access allowed');
require APPPATH . '/libraries/REST_Controller.php';
require APPPATH . '/helpers/jwt_helper.php';
require APPPATH . '/libraries/Paginado.php';

include APPPATH . '/third_party/jwt/JWT.php';
include APPPATH . '/third_party/jwt/BeforeValidException.php';
include APPPATH . '/third_party/jwt/ExpiredException.php';
include APPPATH . '/third_party/jwt/SignatureInvalidException.php';

use Firebase\JWT\JWT;

class Datos7 extends REST_Controller
{


    public function __construct()
    {
        parent::__construct();
        $token = $this->input->get_request_header('Authorization', true);
        $token = Jwt_helper::verificarToken($token);

        if($token["status"] == 'HTTP_UNAUTHORIZED')
        {
             // Devolviendo el mensaje de error con un codigo 401 HTTP_UNAUTHORIZED
             $this->response($token["message"], REST_Controller::HTTP_UNAUTHORIZED);
        }

         $this->load->model('Datos7_model');
    }


 
    public function agregar7_post()
    {
        $post = (array) json_decode($this->post('form'));
        $respuesta = $this->Datos7_model->agregar7($post);
        $this->response($respuesta, $respuesta['status']);
    }
    public function agregar7_add_post()
    {
        $post = (array) json_decode($this->post('form'));
        $respuesta = $this->Datos7_model->agregar7_add($post);
        $this->response($respuesta, $respuesta['status']);
    }

    public function baja_add_post()
    {
        $post = (array) json_decode($this->post('form'));
        $respuesta = $this->Datos7_model->bajaDependiente($post);
        $this->response($respuesta, $respuesta['status']);
    }


    public function formato7_get()
    {
        $respuesta = $this->Datos7_model->obtener7($this->get());
        $this->response($respuesta, $respuesta['status']);
    }

    public function formato7_add_get()
    {
        $respuesta = $this->Datos7_model->obtener7_add($this->get());
        $this->response($respuesta, $respuesta['status']);
    }

    // public function formato7_add_get()
    // {
    //     $respuesta = $this->Datos7_model->obtenerDependientes($this->get());
    //     $this->response($respuesta, $respuesta['status']);
    // }

    public function index_post()
    {
        $respuesta = $this->Datos7_model->obtenerDependientes($this->post('idformato'), $this->post('iddependiente'));
        $this->response($respuesta);
    }

    public function agregar7_ii_post()
    {
        $post = (array) json_decode($this->post('form'));
        $respuesta = $this->Datos7_model->agregar7_ii($post);
        $this->response($respuesta, $respuesta['status']);
    }


    public function formato7_ii_get()
    {
        $respuesta = $this->Datos7_model->obtener7_ii($this->get());
        $this->response($respuesta, $respuesta['status']);
    }

    public function index_get()
    {
        $respuesta = $this->Datos7_model->obtenerTiposSector();
        $this->response($respuesta["respuesta"], $respuesta["status"]);
    }


    //Adicionales
    public function formato7_ii_add_get()
    {
        $respuesta = $this->Datos7_model->obtener7_ii_add($this->get());
        $this->response($respuesta, $respuesta['status']);
    }

    public function index2_post()
    {
        $respuesta = $this->Datos7_model->obtener_add_ii($this->post('idformato'), $this->post('idfideicomiso'));
        $this->response($respuesta);
    }

    public function agregar7_ii_add_post()
    {
        $post = (array) json_decode($this->post('form'));
        $respuesta = $this->Datos7_model->agregar7_ii_add($post);
        $this->response($respuesta, $respuesta['status']);
    }

    public function baja_add_ii_post()
    {
        $post = (array) json_decode($this->post('form'));
        $respuesta = $this->Datos7_model->bajaFideicomiso($post);
        $this->response($respuesta, $respuesta['status']);
    }

  
}
