<?php
defined('BASEPATH') or exit('No direct script access allowed');
require APPPATH . '/libraries/REST_Controller.php';
require APPPATH . '/helpers/jwt_helper.php';
include APPPATH . '/third_party/jwt/JWT.php';
include APPPATH . '/third_party/jwt/BeforeValidException.php';
include APPPATH . '/third_party/jwt/ExpiredException.php';
include APPPATH . '/third_party/jwt/SignatureInvalidException.php';

use Firebase\JWT\JWT;

class Declaracion extends REST_Controller
{
    public function __construct()
    {
        parent::__construct();
        $token = $this->input->get_request_header('Authorization', true);
        $token = Jwt_helper::verificarToken($token);

        if($token["status"] == 'HTTP_UNAUTHORIZED')
        {
             // Devolviendo el mensaje de error con un codigo 401 HTTP_UNAUTHORIZED
             $this->response($token["message"], REST_Controller::HTTP_UNAUTHORIZED);
        }
        $this->load->model('declaracion_model');
    }


 

    public function agregar_post()
    {
        $this->load->model('declaracion_model');
        $data = (array) json_decode($this->post('data'));
        $respuesta = $this->declaracion_model->agregarRegistro($data, $this->post());
        $this->response($respuesta, $respuesta['status']);
    }
    public function documentospag_post()
    {
        $this->load->model('declaracion_model');
        $respuesta = $this->declaracion_model->paginado($this->post());
        $this->response($respuesta);
    }
    // Obtener el paginador
    // public function registrospag_post()
    // {
    //     $this->load->model('declaracion_model');
    //     $respuesta = $this->declaracion_model->paginado($this->post());
    //     $this->response($respuesta["respuesta"], $respuesta["status"]);
    // }

    public function paginado_post()
    {
        $this->load->model('formato_model');
        $respuesta = $this->formato_model->paginado($this->post());
        $this->response($respuesta);
    }

    
    public function eliminar_doc_post()
    {
        $this->load->model('declaracion_model');
        $respuesta = $this->declaracion_model->eliminar_doc($this->post());
        $this->response($respuesta);
    }


    public function obtener_post()
    {
        // $this->load->model('declaracion_model');
        // $respuesta = $this->declaracion_model->obtenerDoc($this->get());
        // $this->response($respuesta, $respuesta['status']);


        $respuesta = $this->declaracion_model->obtenerDoc($this->post('idformato'));
        $this->response($respuesta);
    }

    public function obtener_pdf_post()
    {
        $respuesta = $this->declaracion_model->obtenerDocPdf($this->post('idformato'));
        $this->response($respuesta);
    }

    public function Doc_get()
    {
        $respuesta = $this->declaracion_model->consultaDocumentos($this->get());
        $this->response($respuesta, $respuesta['status']);
    }

    

}