<?php

use setasign\Fpdi\Fpdi;

require_once APPPATH . "/third_party/fpdf/fpdf.php";
require_once APPPATH . "/third_party/fpdi/src/autoload.php";


function plantilla14_add($idformato, $pdf)
{
    //echo "******************************** ", $idformato;
    $CI = &get_instance();
    $CI->load->database();
    $pdf->SetFont('Arial');
    $pdf->SetTextColor(0, 0, 0);
    $pdf->SetXY(30, 35);
    $pdf->SetFontSize(8);
    $y = 1;

    $where = array('idformato' => $idformato);
    $query7 = $CI->db->get_where('14_prestamos_add', $where, 1);
    $codigo_14_add = $query7->row();
    $pdf->SetTextColor(0, 0, 0);

    $where = array('idformato' => $idformato);
    $query = $CI->db->get_where('formatos', $where, 1);
    $codigo = $query->row();

    $CI->db->select('*')->from('14_prestamos_add')->where('idformato', $idformato)->where('activo', 1);
    $consulta = $CI->db->get()->result_array();
    $lenght = count($consulta) - 1;

    

   

    for ($x = 0; $x <= $lenght; $x++) {
        $datos = array(
            'idprestamo' => $consulta[$x]['idprestamo'],
            'inmueble' => $consulta[$x]['inmueble'],
            'tipo_bien' => $consulta[$x]['tipo_bien'],
            'tipo_bien_esp' => $consulta[$x]['tipo_bien_esp'],
            'calle' => $consulta[$x]['calle'],
            'numero_ext' => $consulta[$x]['numero_ext'],
            'numero_int' => $consulta[$x]['numero_int'],
            'localidad' => $consulta[$x]['localidad'],
            'codigo_postal' => $consulta[$x]['codigo_postal'],
            'municipio_estado' => $consulta[$x]['municipio_estado'],
            'entidad_pais' => $consulta[$x]['entidad_pais'],
            'mexico_extranjero' => $consulta[$x]['mexico_extranjero'],
            'vehiculo' => $consulta[$x]['vehiculo'],
            'tipo_vehiculo' => $consulta[$x]['tipo_vehiculo'],
            'tipo_vehiculo_esp' => $consulta[$x]['tipo_vehiculo_esp'],
            'marca' => $consulta[$x]['marca'],
            'modelo' => $consulta[$x]['modelo'],
            'anio' => $consulta[$x]['anio'],
            'numero_serie' => $consulta[$x]['numero_serie'],
            'mexico_extranjero2' => $consulta[$x]['mexico_extranjero2'],
            'entidad_pais_registro' => $consulta[$x]['entidad_pais_registro'],
            'titular' => $consulta[$x]['titular'],
            'nombre_titular' => $consulta[$x]['nombre_titular'],
            'rfc_titular' => $consulta[$x]['rfc_titular'],
            'relacion_titular' => $consulta[$x]['relacion_titular'],
            'aclaraciones' => $consulta[$x]['aclaraciones'],

        );
$y++;
        if ($codigo_14_add->idformato == $idformato) {

            //if ($codigo->tipo_formato == 1) {
                $pdf->setSourceFile('plantillas/Prestamo_14_In.pdf');
            // }else{
            //     $pdf->setSourceFile('plantillas/Prestamo_14.pdf');
            // }
            $pdf->AddPage();
            $tplIdx = $pdf->importPage(1);
            $pdf->useTemplate($tplIdx, 0, 0);

            $pdf->SetFont('Arial', 'B', 9);
            $pdf->SetTextColor(255, 255, 255);
            $pdf->SetFillColor(122, 70, 100);
            $pdf->SetY(26);
            $pdf->SetX(176);
            $pdf->MultiCell(27, 6, utf8_decode('NÚMERO # ' . $y), 0, 0, true);
            $pdf->SetY(26);
            $pdf->SetX(13);
            $pdf->MultiCell(152, 6, ' ', 0, 0, true);
            $pdf->SetFont('Arial', '', 8);
            $pdf->SetTextColor(0, 0, 0);
            //14. PRESTAMO O COMODATO POR TERCEROS

            if ($datos["vehiculo"] == '1') {
                $logo = SERVIDOR . APP . 'application/images/check.png';
                $pdf->Image($logo, 34.3, 121.8, 4, 4);
            } else {
                $logo = SERVIDOR . APP . 'application/images/remove.png';
                $pdf->Image($logo, 34.3, 121.8, 4, 4);;
            }

            if ($datos["inmueble"] == '1') {
                $logo = SERVIDOR . APP . 'application/images/check.png';
                $pdf->Image($logo, 34.1, 65, 4, 4);
            } else {
                $logo = SERVIDOR . APP . 'application/images/remove.png';
                $pdf->Image($logo, 34.1, 65, 4, 4);
            }

            $pdf->SetY(70);
            $pdf->SetX(44);
            if ($datos["tipo_bien"] == 'OTRO / ESPECIFIQUE') {
                $pdf->Cell(154, 4, utf8_decode($datos["tipo_bien_esp"]));
            } else {
                $pdf->Cell(154, 4, utf8_decode($datos["tipo_bien"]));
            }

            $pdf->Ln(9.5);
            $pdf->SetX(105);
            $pdf->Cell(92, 4, utf8_decode($datos["mexico_extranjero"]));
            $pdf->Ln(13);
            $pdf->SetX(13);
            $pdf->Cell(70, 4, utf8_decode($datos["calle"]));
            $pdf->Cell(18, 4, utf8_decode($datos["numero_ext"]));
            $pdf->Cell(18, 4, utf8_decode($datos["numero_int"]));
            $pdf->Cell(70, 4, utf8_decode($datos["localidad"]));
            $pdf->Ln(10);
            $pdf->SetX(13);
            $pdf->Cell(80, 4, utf8_decode($datos["municipio_estado"]));
            $pdf->Cell(76, 4, utf8_decode($datos["entidad_pais"]));
            $pdf->Cell(28, 4, utf8_decode($datos["codigo_postal"]));
            $pdf->Ln(16);
            $pdf->SetX(152);
            $pdf->Cell(45, 4, utf8_decode($datos["mexico_extranjero2"]));
            $pdf->Ln(6.5);
            $pdf->SetX(44);


            if ($datos["tipo_vehiculo"] == 'OTRO / ESPECIFIQUE') {
                $pdf->Cell(42, 4, utf8_decode($datos["tipo_vehiculo_esp"]));
            } else {
                $pdf->Cell(42, 4, utf8_decode($datos["tipo_vehiculo"]));
            }
            $pdf->SetX(125);
            $pdf->Cell(75, 4, utf8_decode($datos["entidad_pais_registro"]));
            $pdf->Ln(11);
            $pdf->SetX(13);
            $pdf->Cell(48, 4, utf8_decode($datos["marca"]));
            $pdf->Cell(46, 4, utf8_decode($datos["modelo"]));
            $pdf->Cell(43, 4, utf8_decode($datos["anio"]));
            $pdf->Cell(49, 4, utf8_decode($datos["numero_serie"]));
            $pdf->Ln(9.5);
            $pdf->SetX(13);
            $pdf->Cell(48, 4, utf8_decode($datos["titular"]));
            $pdf->Cell(136, 4, utf8_decode($datos["nombre_titular"]));
            $pdf->Ln(9);
            $pdf->SetX(13);
            $pdf->Cell(48, 4, utf8_decode($datos["rfc_titular"]));
            $pdf->Cell(136, 4, utf8_decode($datos["relacion_titular"]));
            $pdf->SetY(164.5);
            $pdf->SetX(13);
            $pdf->MultiCell(184, 3.5, utf8_decode($datos["aclaraciones"]));

            // $pdf->SetFont('Arial', 'B', 8);
            // if ($datos["mexico_extranjero2"] == 'EN EL EXTRANJERO') {
            //     $pdf->Text(90, 128, utf8_decode('PAÍS'));
            // } else {
            //     $pdf->Text(90, 128, utf8_decode('ENTIDAD FEDERATIVA'));
            // }

            $pdf->SetFont('Arial', 'B', 8);
            if ($datos["mexico_extranjero2"] == 'EN EL EXTRANJERO') {
                $pdf->Text(145, 91, 'CIUDAD/LOCALIDAD');
                $pdf->Text(37, 100, 'ESTADO/PROVINCIA');
                $pdf->Text(114, 100, utf8_decode('PAÍS'));
            } else {
                $pdf->Text(145, 91, 'COLONIA/LOCALIDAD');
                $pdf->Text(37, 100, utf8_decode('MUNICIPIO/ALCALDÍA'));
                $pdf->Text(114, 100, utf8_decode('ENTIDAD FEDERATIVA'));
            }
            $pdf->SetFont('Arial', '', 8);


            
        }
    }

    //  return $pdf->Output("ejemplo.pdf", 'I', false);
}
