<?php

use setasign\Fpdi\Fpdi;

require_once APPPATH . "/third_party/fpdf/fpdf.php";
require_once APPPATH . "/third_party/fpdi/src/autoload.php";


function plantilla1ii_add($idformato,$pdf)
{
    $CI = &get_instance();
    $CI->load->database();
    $pdf->SetFont('Arial');
    $pdf->SetTextColor(0, 0, 0);
    $pdf->SetXY(30, 35);
    $pdf->SetFontSize(8);
    $y = 1;
    $where = array('idformato' => $idformato);
    $query7 = $CI->db->get_where('1_ii_participacion_empresas_add', $where, 1);
    $codigo_1ii_add = $query7->row();
    $pdf->SetTextColor(0, 0, 0);

    $where = array('idformato' => $idformato);
    $query = $CI->db->get_where('formatos', $where, 1);
    $codigo = $query->row();

    $CI->db->select('*')->from('1_ii_participacion_empresas_add')->where('idformato', $idformato)->where('activo', 1);
    $consulta = $CI->db->get()->result_array();
    $lenght = count($consulta) - 1;

    for ($x = 0; $x <= $lenght; $x++) {
        $datos = array(
            $id = $consulta[$x]['idparticipacion'],
            'idparticipacion' => $consulta[$x]['idparticipacion'],
            'declarante' => $consulta[$x]['declarante'],
            'nombre_empresa' => $consulta[$x]['nombre_empresa'],
            'rfc' => $consulta[$x]['rfc'],
            'porcentaje' => $consulta[$x]['porcentaje'],
            'tipo_participacion' => $consulta[$x]['tipo_participacion'],
            'remuneracion' => $consulta[$x]['remuneracion'],
            'monto_mensual' => $consulta[$x]['monto_mensual'],
            'mexico_extranjero' => $consulta[$x]['mexico_extranjero'],
            'entidad_pais' => $consulta[$x]['entidad_pais'],
            'sector_productivo' => $consulta[$x]['sector_productivo'],
            'aclaraciones' => $consulta[$x]['aclaraciones'],

        );

        $where = array('idformato' => $idformato, 'idparticipacion' => $id);
        $CI->db->select('tipos_sector.nombre as nombre');
        $CI->db->from('1_ii_participacion_empresas_add');
        $CI->db->join('tipos_sector', '1_ii_participacion_empresas_add.sector_productivo=tipos_sector.idtipo_sector');
        $CI->db->where($where);;
        $query = $CI->db->get();
        $view_tipos1 = $query->row();

        $y++;
        if ($codigo_1ii_add->idformato == $idformato) {

            $pdf->setSourceFile('plantillas/II_Declaracion_Intereses/II_1_Participacion.pdf');
            $pdf->AddPage();
            $tplIdx = $pdf->importPage(1);
            $pdf->useTemplate($tplIdx, 0, 0);

            $pdf->SetFont('Arial', 'B', 9);
            $pdf->SetTextColor(255, 255, 255);
            $pdf->SetFillColor(122, 70, 100);
            if ($codigo->tipo_formato == 1) {
                $pdf->SetY(31);
                $pdf->SetX(176);
                $pdf->MultiCell(27, 6, utf8_decode('   '), 0, 0, true);
            }
            $pdf->SetY(37);
            $pdf->SetX(176);
            $pdf->MultiCell(27, 6, utf8_decode('NÚMERO # ' . $y), 0, 0, true);
            $pdf->SetTextColor(0, 0, 0);




            $pdf->SetFont('Arial', 'B', 8);
            if (utf8_decode($datos["mexico_extranjero"]) == 'EN EL EXTRANJERO') {
                $pdf->Text(95, 110, utf8_decode('PAÍS DONDE SE LOCALIZA'));
            } else {
                $pdf->Text(100, 110, utf8_decode('ENTIDAD FEDERATIVA'));
            }

            $pdf->SetFont('Arial', '', 8);
            $pdf->SetY(67);
            $pdf->SetX(13);
            $pdf->Cell(92, 4, utf8_decode($datos["declarante"]));
            $pdf->Ln(8);
            $pdf->SetX(13);
            $pdf->Cell(92, 4, utf8_decode($datos["nombre_empresa"]));
            $pdf->Ln(8);
            $pdf->SetX(13);
            $pdf->Cell(94, 4, utf8_decode($datos["rfc"]));
            $pdf->Cell(92, 4, utf8_decode($datos["porcentaje"]));
            $pdf->Ln(8);
            $pdf->SetX(13);
            if ($datos["tipo_participacion"] == 'OTRO / ESPECIFIQUE') {
                $pdf->Cell(92, 4, utf8_decode($datos["tipo_participacion_esp"]));
            } else {
                $pdf->Cell(92, 4, utf8_decode($datos["tipo_participacion"]));
            }
            $pdf->Ln(8.5);
            $pdf->SetX(13);
            $pdf->Cell(94, 4, utf8_decode($datos["remuneracion"]));
            $pdf->Cell(92, 4, utf8_decode($datos["monto_mensual"]));
            $pdf->Ln(3.5);
            $pdf->SetX(105);
            $pdf->Cell(92, 4, utf8_decode($datos["mexico_extranjero"]));
            $pdf->Ln(8);
            $pdf->SetX(13);
            $pdf->Cell(92, 4, utf8_decode($datos["entidad_pais"]));
            $pdf->Ln(8);
            $pdf->SetX(13);

            if ($datos["sector_productivo"] == '17') {
                $pdf->Cell(92, 4, utf8_decode($datos["entidad_pais"]));
            } else {
                if ($view_tipos1) {
                    $pdf->Cell(92, 4, utf8_decode($view_tipos1->nombre));
                }
            }
            $pdf->SetY(128);
            $pdf->SetX(13);
            $pdf->MultiCell(184, 3.5, utf8_decode($datos["aclaraciones"]));
        }
    }

}

