<?php

use setasign\Fpdi\Fpdi;

require_once APPPATH . "/third_party/fpdf/fpdf.php";
require_once APPPATH . "/third_party/fpdi/src/autoload.php";


function plantilla3ii_add($idformato,$pdf)
{
    $CI = &get_instance();
    $CI->load->database();
    $pdf->SetFont('Arial');
    $pdf->SetTextColor(0, 0, 0);
    $pdf->SetXY(30, 35);
    $pdf->SetFontSize(8);
    $y = 1;
    $where = array('idformato' => $idformato);
    $query7 = $CI->db->get_where('3_ii_apoyos_add', $where, 1);
    $codigo_3ii_add = $query7->row();
    $pdf->SetTextColor(0, 0, 0);



    $CI->db->select('*')->from('3_ii_apoyos_add')->where('idformato', $idformato)->where('activo', 1);
    $consulta = $CI->db->get()->result_array();
    $lenght = count($consulta) - 1;

    for ($x = 0; $x <= $lenght; $x++) {
        $datos = array(
            'idapoyo' => $consulta[$x]['idapoyo'],
            'beneficiario' => $consulta[$x]['beneficiario'],
            'nombre_programa' => $consulta[$x]['nombre_programa'],
            'institucion' => $consulta[$x]['institucion'],
            'nivel_gobierno' => $consulta[$x]['nivel_gobierno'],
            'tipo_apoyo' => $consulta[$x]['tipo_apoyo'],
            'tipo_apoyo_esp' => $consulta[$x]['tipo_apoyo_esp'],
            'forma_recepcion' => $consulta[$x]['forma_recepcion'],
            'monto_apoyo' => $consulta[$x]['monto_apoyo'],
            'especifique_apoyo' => $consulta[$x]['especifique_apoyo'],
            'aclaraciones' => $consulta[$x]['aclaraciones'],

        );
        $y++;
        if ($codigo_3ii_add->idformato == $idformato) {

            $pdf->setSourceFile('plantillas/II_Declaracion_Intereses/II_3_Apoyos.pdf');
            $pdf->AddPage();
            $tplIdx = $pdf->importPage(1);
            $pdf->useTemplate($tplIdx, 0, 0);

            $pdf->SetFont('Arial', 'B', 9);
            $pdf->SetTextColor(255, 255, 255);
            $pdf->SetFillColor(122, 70, 100);
            $pdf->SetY(22);
            $pdf->SetX(176);
            $pdf->MultiCell(27, 6, utf8_decode('   '), 0, 0, true);
            $pdf->SetY(27);
            $pdf->SetX(176);
            $pdf->MultiCell(27, 8, utf8_decode('NÚMERO # ' . $y), 0, 0, true);
            $pdf->SetTextColor(0, 0, 0);
            $pdf->SetFont('Arial', '', 8);



            $pdf->SetY(59);
            $pdf->SetX(13);
            $pdf->Cell(92, 4, utf8_decode($datos["beneficiario"]));
            $pdf->Ln(9.5);
            $pdf->SetX(13);
            $pdf->Cell(73, 4, utf8_decode($datos["nombre_programa"]));
            $pdf->Ln(9);
            $pdf->SetX(13);
            $pdf->Cell(64, 4, utf8_decode($datos["institucion"]));
            $pdf->Ln(9.5);
            $pdf->SetX(13);
            $pdf->Cell(47, 4, utf8_decode($datos["nivel_gobierno"]));
            $pdf->Ln(9);
            $pdf->SetX(13);
            if ($datos["tipo_apoyo"] == 'OTRO / ESPECIFIQUE') {
                $pdf->Cell(85, 4, utf8_decode($datos["tipo_apoyo_esp"]));
            } else {
                $pdf->Cell(85, 4, utf8_decode($datos["tipo_apoyo"]));
            }
            $pdf->Ln(9.5);
            $pdf->SetX(13);
            $pdf->Cell(95, 4, utf8_decode($datos["forma_recepcion"]));
            $pdf->Cell(80, 4, utf8_decode($datos["monto_apoyo"]));
            $pdf->Ln(9);
            $pdf->SetX(13);
            $pdf->MultiCell(140, 3.5, utf8_decode($datos["especifique_apoyo"]));
            $pdf->SetY(125);
            $pdf->SetX(13);
            $pdf->MultiCell(184, 3.5, utf8_decode($datos["aclaraciones"]));
        }
    }

}

