<?php

use setasign\Fpdi\Fpdi;

require_once APPPATH . "/third_party/fpdf/fpdf.php";
require_once APPPATH . "/third_party/fpdi/src/autoload.php";


function plantilla4ii_add($idformato,$pdf)
{
    $CI = &get_instance();
    $CI->load->database();
    $pdf->SetFont('Arial');
    $pdf->SetTextColor(0, 0, 0);
    $pdf->SetXY(30, 35);
    $pdf->SetFontSize(8);
    $y = 1;
    $where = array('idformato' => $idformato);
    $query7 = $CI->db->get_where('4_ii_representacion_add', $where, 1);
    $codigo_4ii_add = $query7->row();
    $pdf->SetTextColor(0, 0, 0);

    $CI->db->select('*')->from('4_ii_representacion_add')->where('idformato', $idformato)->where('activo', 1);
    $consulta = $CI->db->get()->result_array();
    $lenght = count($consulta) - 1;

    for ($x = 0; $x <= $lenght; $x++) {
        $datos = array(
            $id = $consulta[$x]['idrepresentacion'],
            'idrepresentacion' => $consulta[$x]['idrepresentacion'],
            'declarante' => $consulta[$x]['declarante'],
            'tipo_representacion' => $consulta[$x]['tipo_representacion'],
            'fecha_inicio' => $consulta[$x]['fecha_inicio'],
            'representante' => $consulta[$x]['representante'],
            'nombre_representante' => $consulta[$x]['nombre_representante'],
            'rfc' => $consulta[$x]['rfc'],
            'remuneracion' => $consulta[$x]['remuneracion'],
            'monto_mensual' => $consulta[$x]['monto_mensual'],
            'mexico_extranjero' => $consulta[$x]['mexico_extranjero'],
            'entidad_pais' => $consulta[$x]['entidad_pais'],
            'sector_productivo' => $consulta[$x]['sector_productivo'],
            'sector_productivo_esp' => $consulta[$x]['sector_productivo_esp'],
            'aclaraciones' => $consulta[$x]['aclaraciones'],
        );


        $where = array('idformato' => $idformato, 'idrepresentacion' => $id);
        $CI->db->select('tipos_sector.nombre as nombre');
        $CI->db->from('4_ii_representacion_add');
        $CI->db->join('tipos_sector', '4_ii_representacion_add.sector_productivo=tipos_sector.idtipo_sector');
        $CI->db->where($where);;
        $query = $CI->db->get();
        $view_tipos4 = $query->row();
        $y++;
        if ($codigo_4ii_add->idformato == $idformato) {

            $pdf->setSourceFile('plantillas/II_Declaracion_Intereses/II_4_Representacion.pdf');
            $pdf->AddPage();
            $tplIdx = $pdf->importPage(1);
            $pdf->useTemplate($tplIdx, 0, 0);

            $pdf->SetFont('Arial', 'B', 9);
            $pdf->SetTextColor(255, 255, 255);
            $pdf->SetFillColor(122, 70, 100);
            $pdf->SetY(23);
            $pdf->SetX(176);
            $pdf->MultiCell(27, 6, utf8_decode('   '), 0, 0, true);
            $pdf->SetY(30);
            $pdf->SetX(176);
            $pdf->MultiCell(27, 6, utf8_decode('NÚMERO # ' . $y), 0, 0, true);
            $pdf->SetTextColor(0, 0, 0);
            $pdf->SetFont('Arial', 'B', 8);
            if ($datos["mexico_extranjero"] == 'EN EL EXTRANJERO') {
                $pdf->Text(90, 110, utf8_decode('PAÍS DONDE SE LOCALIZA'));
            } else {
                $pdf->Text(90, 110, utf8_decode('ENTIDAD FEDERATIVA'));
            }

            $pdf->SetFont('Arial', '', 8);
            $pdf->SetY(59.5);
            $pdf->SetX(13);
            $pdf->Cell(92, 4, utf8_decode($datos["declarante"]));
            $pdf->Ln(9.5);
            $pdf->SetX(13);
            $pdf->Cell(55, 4, utf8_decode($datos["tipo_representacion"]));
            $pdf->Cell(65, 4, utf8_decode($datos["fecha_inicio"]));
            $pdf->Cell(64, 4, utf8_decode($datos["representante"]));
            $pdf->Ln(10);
            $pdf->SetX(13);
            $pdf->Cell(122, 4, utf8_decode($datos["nombre_representante"]));
            $pdf->Ln(9);
            $pdf->SetX(13);
            $pdf->Cell(95, 4, utf8_decode($datos["rfc"]));
            $pdf->Cell(92, 4, utf8_decode($datos["remuneracion"]));
            $pdf->Ln(9.5);
            $pdf->SetX(13);
            $pdf->Cell(92, 4, utf8_decode($datos["monto_mensual"]));
            $pdf->Ln(5.5);
            $pdf->SetX(105);
            $pdf->Cell(92, 4, utf8_decode($datos["mexico_extranjero"]));
            $pdf->Ln(9.5);
            $pdf->SetX(13);
            $pdf->Cell(92, 4, utf8_decode($datos["entidad_pais"]));
            $pdf->Ln(9.5);
            $pdf->SetX(13);
            if ($datos["sector_productivo"] == '17') {
                $pdf->Cell(92, 4, utf8_decode($datos["sector_productivo_esp"]));
            } else {
                // $pdf->Cell(92, 4, utf8_decode($codigo_4_ii->sector_productivo));
                if ($view_tipos4 != null) {
                    $pdf->Cell(92, 4, utf8_decode($view_tipos4->nombre));
                }
            }
            $pdf->SetY(132);
            $pdf->SetX(13);
            $pdf->MultiCell(184, 3.5, utf8_decode($datos["aclaraciones"]));
        }
    }

}

