<?php

use setasign\Fpdi\Fpdi;

require_once APPPATH . "/third_party/fpdf/fpdf.php";
require_once APPPATH . "/third_party/fpdi/src/autoload.php";


function plantilla7ii_add($idformato,$pdf)
{
    $CI = &get_instance();
    $CI->load->database();
    $pdf->SetFont('Arial');
    $pdf->SetTextColor(0, 0, 0);
    $pdf->SetXY(30, 35);
    $pdf->SetFontSize(8);
    $y = 1;
    $where = array('idformato' => $idformato);
    $query7 = $CI->db->get_where('7_ii_fideicomisos_add', $where, 1);
    $codigo_7ii_add = $query7->row();
    $pdf->SetTextColor(0, 0, 0);

    $CI->db->select('*')->from('7_ii_fideicomisos_add')->where('idformato', $idformato)->where('activo', 1);
    $consulta = $CI->db->get()->result_array();
    $lenght = count($consulta) - 1;

    for ($x = 0; $x <= $lenght; $x++) {
        $datos = array(
            $id = $consulta[$x]['idfideicomiso'],
            'idfideicomiso' => $consulta[$x]['idfideicomiso'],
            'participacion' => $consulta[$x]['participacion'],
            'tipo_fideicomiso' => $consulta[$x]['tipo_fideicomiso'],
            'tipo_participacion' => $consulta[$x]['tipo_participacion'],
            'rfc_fideicomiso' => $consulta[$x]['rfc_fideicomiso'],
            'fideicomitente' => $consulta[$x]['fideicomitente'],
            'nombre_fideicomitente' => $consulta[$x]['nombre_fideicomitente'],
            'rfc_fideicomitente' => $consulta[$x]['rfc_fideicomitente'],
            'nombre_fiduciario' => $consulta[$x]['nombre_fiduciario'],
            'rfc_fiduciario' => $consulta[$x]['rfc_fiduciario'],
            'fideicomisario' => $consulta[$x]['fideicomisario'],
            'nombre_fideicomisario' => $consulta[$x]['nombre_fideicomisario'],
            'rfc_fideicomisario' => $consulta[$x]['rfc_fideicomisario'],
            'sector_productivo' => $consulta[$x]['sector_productivo'],
            'sector_productivo_esp' => $consulta[$x]['sector_productivo_esp'],
            'mexico_extranjero' => $consulta[$x]['mexico_extranjero'],
            'aclaraciones' => $consulta[$x]['aclaraciones'],

        );

        $where = array('idformato' => $idformato, 'idfideicomiso' => $id);
        $CI->db->select('tipos_sector.nombre as nombre');
        $CI->db->from('7_ii_fideicomisos_add');
        $CI->db->join('tipos_sector', '7_ii_fideicomisos_add.sector_productivo=tipos_sector.idtipo_sector');
        $CI->db->where($where);
        $query = $CI->db->get();
        $view_tipos7 = $query->row();
        $y++;
        if ($codigo_7ii_add->idformato == $idformato) {

            $pdf->setSourceFile('plantillas/II_Declaracion_Intereses/II_7_Fideicomisos.pdf');
            $pdf->AddPage();
            $tplIdx = $pdf->importPage(1);
            $pdf->useTemplate($tplIdx, 0, 0);

            $pdf->SetFont('Arial', 'B', 9);
            $pdf->SetTextColor(255, 255, 255);
            $pdf->SetFillColor(122, 70, 100);
            $pdf->SetY(20);
            $pdf->SetX(176);
            $pdf->MultiCell(27, 6, utf8_decode('   '), 0, 0, true);
            $pdf->SetY(27);
            $pdf->SetX(176);
            $pdf->MultiCell(26, 6, utf8_decode('NÚMERO # ' . $y), 0, 0, true);
            $pdf->SetTextColor(0, 0, 0);

            $pdf->SetFont('Arial', '', 8);
            $pdf->SetY(66);
            $pdf->SetX(13);
            $pdf->Cell(61, 4, utf8_decode($datos["participacion"]));
            $pdf->Cell(62, 4, utf8_decode($datos["tipo_fideicomiso"]));
            $pdf->Cell(61, 4, utf8_decode($datos["tipo_participacion"]));
            $pdf->Ln(5);
            $pdf->SetX(108);
            $pdf->Cell(92, 4, utf8_decode($datos["rfc_fideicomiso"]));
            $pdf->Ln(11);
            $pdf->SetX(13);
            $pdf->Cell(92, 4, utf8_decode($datos["fideicomitente"]));
            $pdf->Ln(11.5);
            $pdf->SetX(13);
            $pdf->Cell(92, 4, utf8_decode($datos["nombre_fideicomitente"]));
            $pdf->Ln(5.5);
            $pdf->SetX(108);
            $pdf->Cell(92, 4, utf8_decode($datos["rfc_fideicomitente"]));
            $pdf->Ln(11);
            $pdf->SetX(13);
            $pdf->Cell(92, 4, utf8_decode($datos["nombre_fiduciario"]));
            $pdf->Ln(5.5);
            $pdf->SetX(108);
            $pdf->Cell(92, 4, utf8_decode($datos["rfc_fiduciario"]));
            $pdf->Ln(12);
            $pdf->SetX(13);
            $pdf->Cell(48, 4, utf8_decode($datos["fideicomisario"]));
            $pdf->Ln(11);
            $pdf->SetX(13);
            $pdf->Cell(75, 4, utf8_decode($datos["nombre_fideicomisario"]));
            $pdf->Ln(6);
            $pdf->SetX(108);
            $pdf->Cell(60, 4, utf8_decode($datos["rfc_fideicomisario"]));
            $pdf->Ln(11.5);
            $pdf->SetX(13);
            if ($datos["sector_productivo"] == '17') {
                $pdf->Cell(92, 4, utf8_decode($datos["sector_productivo_esp"]));
            } else {
                if ($view_tipos7 != null) {
                    $pdf->Cell(92, 4, utf8_decode($view_tipos7->nombre));
                }
            }
            $pdf->Text(130, 163, utf8_decode($datos["mexico_extranjero"]));
            $pdf->SetY(170);
            $pdf->SetX(13);
            $pdf->MultiCell(184, 3.5, utf8_decode($datos["aclaraciones"]));

        }
    }

}

