<?php
header("Content-Type: text/html;charset=utf-8");
require_once APPPATH . "/third_party/fpdf/fpdf.php";

class Pdf_helper_datos_generales extends FPDF
{
    function Header(){

    }

    public function generarPDF($datos)
    {

        foreach($datos as $llave => $valor)
        {
            if(mb_detect_encoding($valor) == 'UTF-8')
            {
                $datos[$llave] = utf8_decode($valor);
            }
        }

        $pdf = new FPDF('P','mm','letter');
        $pdf->AliasNbPages();
        $pdf->SetAutoPageBreak(true);
        $pdf->AddPage();
        $logo = SERVIDOR . APP . 'application/images/inicio.png';
        $pdf->Image($logo, 9, 0, 200, 30);
        $pdf->SetFont('Arial', 'B', 14);
        $pdf->Ln(25);
        $pdf->SetX(10);
        $pdf->SetFillColor(122, 70, 100);
        $pdf->SetTextColor(255, 255, 255);
        $pdf->MultiCell(198.3, 15, utf8_decode("I. DECLARACIÓN DE SITUACIÓN PATRIMONIAL"), 0, 'C', true);
        $pdf->SetFont('Arial', '', 11);
        $pdf->SetX(45);
        //$pdf->MultiCell(130, 0, utf8_decode("1. DATOS GENERALES"), 0, 'C', 0);
        $pdf->Ln(0);

        // echo $idp;
        $pdf->SetFont('Arial', '', 8);
        $pdf->SetFillColor(135, 214, 161);
        $pdf->SetTextColor(000, 000, 000);
        $pdf->Cell(198.3, 7, utf8_decode("LOS DATOS DE TERCEROS, SIEMPRE Y CUANDO SEAN PERSONAS FÍSICAS, Y LOS DATOS RESALTADOS NO SERÁN PÚBLICOS."), 0, 0, '',true);
        $pdf->Ln(9);
        //**************************************DATOS GENERALES *******************************************************/
        $pdf->SetFont('Arial', 'B', 12);
        $pdf->SetFillColor(122, 70, 100);
        $pdf->SetTextColor(255, 255, 255);
        $pdf->SetX(9.8);
        $pdf->Cell(198.3, 7, "1. DATOS GENERALES", 0, 1, 'C', true);
        $pdf->SetTextColor(000, 000, 000);
        $pdf->SetFont('Arial', '', 8);
        $pdf->Ln(1);
        $pdf->SetFillColor(235, 238, 236);
         $pdf->Cell(66, 7, "NOMBRE (S)", 1, 0, 'C',true);
         $pdf->Cell(66, 7, utf8_decode("PRIMER APELLIDO"), 1, 0,'C', true);
         $pdf->Cell(66, 7, utf8_decode("SEGUNDO APELLIDO"), 1, 1,'C', true);
         $pdf->Cell(66, 7, utf8_decode($datos["nombre"]), 1, 0, '');
         $pdf->Cell(66, 7, utf8_decode($datos["primer_apellido"]), 1, 0, '');
         $pdf->Cell(66, 7, utf8_decode($datos["segundo_apellido"]), 1, 1, '');

        $pdf->Cell(66, 7, "CURP", 1, 0,'C', true);
        $pdf->Cell(66, 7, utf8_decode("RFC"), 1, 0,'C', true);
        $pdf->Cell(66, 7, utf8_decode("HOMOCLAVE"), 1, 1,'C', true);
        $pdf->Cell(66, 7, utf8_decode($datos["curp"]), 1, 0, '');
        $pdf->Cell(66, 7, utf8_decode($datos["rfc"]), 1, 0, '');
        $pdf->Cell(66, 7, utf8_decode($datos["homoclave"]), 1, 1, '');

        $pdf->Cell(66, 7, utf8_decode("CORREO ELECTRÓNICO INSTITUCIONAL"), 1, 0,'C', true);
        $pdf->Cell(66, 7, utf8_decode("CORREO ELECTRÓNICO PERSONAL/ALTERNO"), 1, 0,'C', true);
        $pdf->Cell(66, 7, utf8_decode("NÚMERO TELEFÓNICO DE CASA"), 1, 1,'C', true);
        $pdf->Cell(66, 7, utf8_decode($datos["correo_institucional"]), 1, 0, '');
        $pdf->Cell(66, 7, utf8_decode($datos["correo_personal"]), 1, 0, '');
        $pdf->Cell(66, 7, utf8_decode($datos["numero_casa"]), 1, 1, '');

        $pdf->Cell(66, 7, utf8_decode("NÚMERO CELULAR PERSONAL"), 1, 0,'C', true);
        $pdf->Cell(66, 7, utf8_decode("SITUACIÓN PERSONAL/ESTADO CIVIL"), 1, 0,'C', true);
        $pdf->Cell(66, 7, utf8_decode("RÉGIMEN MATRIMONIAL"), 1, 1,'C', true);
        $pdf->Cell(66, 7, utf8_decode($datos["numero_celular"]), 1, 0, '');
        $pdf->Cell(66, 7, utf8_decode($datos["estado_civil"]), 1, 0, '');
        if (($datos["regimen_matrimonial_esp"]) != null
        ) { $pdf->Cell(66, 7, utf8_decode($datos["regimen_matrimonial_esp"]), 1, 1, '');}
        else{$pdf->Cell(66, 7, utf8_decode($datos["regimen_matrimonial"]), 1, 1, ''); }
        $pdf->Cell(99, 7, utf8_decode("PAÍS DE NACIMIENTO"), 1, 0,'C', true);
        $pdf->Cell(99, 7, utf8_decode("NACIONALIDAD"), 1, 1,'C', true);
        $pdf->Cell(99, 7, utf8_decode(utf8_encode($datos["pais_nacimiento"])), 1, 0, '');
        $pdf->Cell(99, 7, utf8_decode($datos["nacionalidad"]), 1, 1, '');
      
        $pdf->Cell(198, 7, utf8_decode("ACLARACIONES / OBSERVACIONES"), 1, 1,'C', true);
        $pdf->Cell(198, 7, utf8_decode($datos["observaciones"]), 1, 1, '');

        $pdf->Ln(5);
        $pdf->SetFont('Arial', 'B', 12);
        $pdf->SetFillColor(122, 70, 100);
        $pdf->SetTextColor(255, 255, 255);
        $pdf->SetX(9.8);
        $pdf->Cell(198.3, 7, "2. DOMICILIO DEL DECLARANTE", 0, 1, 'C', true);
        $pdf->SetTextColor(000, 000, 000);
        $pdf->SetFont('Arial', '', 8);
        $pdf->Ln(1);
        $pdf->SetFillColor(235, 238, 236);
        $pdf->Cell(99, 7, utf8_decode("MÉXICO / EXTRANJERO: "), 1, 0, 'R', true);
        $pdf->Cell(99, 7, utf8_decode($datos["mexico_extranjero"]), 1, 1, '');
        $pdf->Cell(66, 7, "CALLE", 1, 0, 'C', true);
        $pdf->Cell(33, 7, utf8_decode("NÚMERO EXTERIOR"), 1, 0, 'C', true);
        $pdf->Cell(33, 7, utf8_decode("NÚMERO INTERIOR"), 1, 0, 'C', true);
        $pdf->Cell(66, 7, utf8_decode("COLONIA/LOCALIDAD"), 1, 1, 'C', true);
        $pdf->Cell(66, 7, utf8_decode($datos["calle"]), 1, 0, '');
        $pdf->Cell(33, 7, utf8_decode($datos["numero_ext"]), 1, 0, '');
        $pdf->Cell(33, 7, utf8_decode($datos["numero_int"]), 1, 0, '');
        $pdf->Cell(66, 7, utf8_decode($datos["localidad"]), 1, 1, '');

        $pdf->Cell(66, 7, "ESTADO / PROVINCIA", 1, 0, 'C', true);
        $pdf->Cell(66, 7, utf8_decode("PAÍS"), 1, 0, 'C', true);
        $pdf->Cell(66, 7, utf8_decode("CÓDIGO POSTAL"), 1, 1, 'C', true);
        $pdf->Cell(66, 7, utf8_decode($datos["municipio_estado"]), 1, 0, '');
        $pdf->Cell(66, 7, utf8_decode($datos["entidad_pais"]), 1, 0, '');
        $pdf->Cell(66, 7, utf8_decode($datos["codigo_postal"]), 1, 1, '');

        $pdf->Cell(198, 7, utf8_decode("ACLARACIONES / OBSERVACIONES"), 1, 1, 'C', true);
        $pdf->Cell(198, 7, utf8_decode($datos["aclaraciones"]), 1, 1, '');
       

 





        $fin = SERVIDOR . APP . 'application/images/fin-hoja.png';
        $pdf->Image($fin, 0, 260, 220, 20); 
        $pdf->Output('formato_'.$datos['idformato'].'.pdf','I',true);
        
       
    }

}

?>