<?php

use setasign\Fpdi\Fpdi;

require_once APPPATH . "/third_party/fpdf/fpdf.php";
require_once APPPATH . "/third_party/fpdi/src/autoload.php";


function plantilla1ii($idformato,$pdf)
{
    $CI = &get_instance();
    $CI->load->database();
    $pdf->SetFont('Arial');
    $pdf->SetTextColor(0, 0, 0);
    $pdf->SetXY(30, 35);
    $pdf->SetFontSize(8);
    $where = array('idformato' => $idformato);
    $query = $CI->db->get_where('1_ii_participacion_empresas', $where, 1);
    $codigo_1_ii = $query->row();

    $where = array('idformato' => $idformato);
    $CI->db->select('tipos_sector.nombre as nombre');
    $CI->db->from('1_ii_participacion_empresas');
    $CI->db->join('tipos_sector', '1_ii_participacion_empresas.sector_productivo=tipos_sector.idtipo_sector');
    $CI->db->where($where);;
    $query = $CI->db->get();
    $view_tipos1 = $query->row();

    $where = array('idformato' => $idformato);
    $query = $CI->db->get_where('formatos', $where, 1);
    $codigo = $query->row();


    //II- DECLARACIÓN DE INTERESES
    //1. PARTICIPACIÓN EN EMPRESAS, SOCIEDADES O ASOCIACIONES
    $pdf->SetFont('Arial', 'B', 8);
    if ($codigo_1_ii->mexico_extranjero == 'EN EL EXTRANJERO') {
        $pdf->Text(95, 110, utf8_decode('PAÍS DONDE SE LOCALIZA'));
    } else {
        $pdf->Text(100, 110, utf8_decode('ENTIDAD FEDERATIVA'));
    }

    if ($codigo_1_ii->ninguno == '1') {
        $logo = SERVIDOR . APP . 'application/images/check2.png';
        $pdf->Image($logo, 197.4, 38.5, 4, 4);
    }
    //SIN CAMBIO--SOLO PARA FORMATO MOD
    if ($codigo_1_ii->ninguno == '2') {
        $logo = SERVIDOR . APP . 'application/images/check2.png';
        $pdf->Image($logo, 197.5, 31.5, 4, 4);
    }
    //FORMATO INICIAL
    if ($codigo->tipo_formato == 1) {
        $pdf->SetY(31);
        $pdf->SetX(176);
        $pdf->MultiCell(27, 6, utf8_decode('   '), 0, 0, true);
    }
    //AGREGO POR LO MENOS 1
    if ($codigo_1_ii->ninguno == '0') {
        $pdf->SetFont('Arial', 'B', 9);
        $pdf->SetTextColor(255, 255, 255);
        $pdf->SetFillColor(122, 70, 100);
        $pdf->SetY(37);
        $pdf->SetX(176);
        $pdf->MultiCell(27, 6, utf8_decode('NÚMERO # 1'), 0, 0, true);
    } 

    $pdf->SetTextColor(0, 0, 0);
    $pdf->SetFont('Arial', '', 8);
    $pdf->SetY(67);
    $pdf->SetX(13);
    $pdf->Cell(92, 4, utf8_decode($codigo_1_ii->declarante));
    $pdf->Ln(8);
    $pdf->SetX(13);
    $pdf->Cell(92, 4, utf8_decode($codigo_1_ii->nombre_empresa));
    $pdf->Ln(8);
    $pdf->SetX(13);
    $pdf->Cell(94, 4, utf8_decode($codigo_1_ii->rfc));
    $pdf->Cell(92, 4, utf8_decode($codigo_1_ii->porcentaje));
    $pdf->Ln(8);
    $pdf->SetX(13);
    if ($codigo_1_ii->tipo_participacion == 'OTRO / ESPECIFIQUE') {
        $pdf->Cell(92, 4, utf8_decode($codigo_1_ii->tipo_participacion_esp));
    } else {
        $pdf->Cell(92, 4, utf8_decode($codigo_1_ii->tipo_participacion));
    }
    $pdf->Ln(8.5);
    $pdf->SetX(13);
    $pdf->Cell(94, 4, utf8_decode($codigo_1_ii->remuneracion));
    $pdf->Cell(92, 4, utf8_decode($codigo_1_ii->monto_mensual));
    $pdf->Ln(3.5);
    $pdf->SetX(105);
    $pdf->Cell(92, 4, utf8_decode($codigo_1_ii->mexico_extranjero));
    $pdf->Ln(8);
    $pdf->SetX(13);
    $pdf->Cell(92, 4, utf8_decode($codigo_1_ii->entidad_pais));
    $pdf->Ln(8);
    $pdf->SetX(13);

    if ($codigo_1_ii->sector_productivo == '17') {
        $pdf->Cell(92, 4, utf8_decode($codigo_1_ii->sector_productivo_esp));
    } else {
        if ($view_tipos1) {
            $pdf->Cell(92, 4, utf8_decode($view_tipos1->nombre));
        }
    }
    $pdf->SetY(128);
    $pdf->SetX(13);
    $pdf->MultiCell(184, 3.5, utf8_decode($codigo_1_ii->aclaraciones));

}

