<?php

use setasign\Fpdi\Fpdi;

require_once APPPATH . "/third_party/fpdf/fpdf.php";
require_once APPPATH . "/third_party/fpdi/src/autoload.php";


function plantilla2ii($idformato,$pdf)
{
    $CI = &get_instance();
    $CI->load->database();
    $pdf->SetFont('Arial');
    $pdf->SetTextColor(0, 0, 0);
    $pdf->SetXY(30, 35);
    $pdf->SetFontSize(8);
    $where = array('idformato' => $idformato);
    $query = $CI->db->get_where('2_ii_toma_decisiones', $where, 1);
    $codigo_2_ii = $query->row();

    $where = array('idformato' => $idformato);
    $query = $CI->db->get_where('formatos', $where, 1);
    $codigo = $query->row();

    //II- DECLARACIÓN DE INTERESES
    //2. ¿ PARTICIPA EN LA TOMA DE DECISIONES DE ALGUNA DE ESTAS INSTITUCIONES ?
    if ( $codigo_2_ii->ninguno == '1' ) {
        $logo = SERVIDOR . APP . 'application/images/check2.png';
        $pdf->Image($logo, 197.3, 35.2, 4, 4);
    }


    //SIN CAMBIO--SOLO PARA FORMATO MOD
    if ($codigo_2_ii->ninguno == '2') {
        $logo = SERVIDOR . APP . 'application/images/check2.png';
        $pdf->Image($logo, 197.5, 29, 4, 4);
    }
    //FORMATO INICIAL
    if ($codigo->tipo_formato == 1) {
        $pdf->SetY(28);
        $pdf->SetX(176);
        $pdf->MultiCell(27, 6, utf8_decode('   '), 0, 0, true);
    }
    //AGREGO POR LO MENOS 1
    if ($codigo_2_ii->ninguno == '0') {
        $pdf->SetFont('Arial', 'B', 9);
        $pdf->SetTextColor(255, 255, 255);
        $pdf->SetFillColor(122, 70, 100);
        $pdf->SetY(34);
        $pdf->SetX(176);
        $pdf->MultiCell(27, 6, utf8_decode('NÚMERO # 1'), 0, 0, true);
    } 

    $pdf->SetTextColor(0, 0, 0);
    $pdf->SetFont('Arial', 'B', 8);
    if ($codigo_2_ii->mexico_extranjero == 'EN EL EXTRANJERO') {
        $pdf->Text(90, 124, utf8_decode('PAÍS DONDE SE LOCALIZA'));
    } else {
        $pdf->Text(90, 124, utf8_decode('ENTIDAD FEDERATIVA'));
    }
    $pdf->SetFont('Arial', '', 8);
    $pdf->SetY(71);
    $pdf->SetX(13);
    $pdf->Cell(92, 4, utf8_decode($codigo_2_ii->declarante));
    $pdf->Ln(9);
    $pdf->SetX(13);
    $pdf->Cell(92, 4, utf8_decode($codigo_2_ii->nombre_institucion));
    $pdf->Ln(9);
    $pdf->SetX(13);
    $pdf->Cell(95, 4, utf8_decode($codigo_2_ii->rfc));
    $pdf->Cell(92, 4, utf8_decode($codigo_2_ii->puesto));
    $pdf->Ln(9);
    $pdf->SetX(13);
    if ($codigo_2_ii->tipo_institucion == 'OTRO / ESPECIFIQUE') {
        $pdf->Cell(85, 4, utf8_decode($codigo_2_ii->tipo_institucion_esp));
    } else {
        $pdf->Cell(85, 4, utf8_decode($codigo_2_ii->tipo_institucion));
    }
    $pdf->Ln(9);
    $pdf->SetX(13);

    $pdf->Cell(105, 4, utf8_decode($codigo_2_ii->fecha_inicio));
    $pdf->Cell(80, 4, utf8_decode($codigo_2_ii->monto_mensual));
    $pdf->Ln(4.6);
    $pdf->SetX(155);
    $pdf->Cell(42, 4, utf8_decode($codigo_2_ii->remuneracion));
    $pdf->Ln(4.5);
    $pdf->SetX(105);
    $pdf->Cell(92, 4, utf8_decode($codigo_2_ii->mexico_extranjero));
    $pdf->Ln(9);
    $pdf->SetX(13);
    $pdf->Cell(92, 4, utf8_decode($codigo_2_ii->entidad_pais));
    $pdf->SetY(135);
    $pdf->SetX(13);
    $pdf->MultiCell(184, 3.5, utf8_decode($codigo_2_ii->aclaraciones));

}

