<?php

use setasign\Fpdi\Fpdi;

require_once APPPATH . "/third_party/fpdf/fpdf.php";
require_once APPPATH . "/third_party/fpdi/src/autoload.php";


function plantilla6($idformato,$pdf)
{
    $CI = &get_instance();
    $CI->load->database();
    $pdf->SetFont('Arial');
    $pdf->SetTextColor(0, 0, 0);
    $pdf->SetXY(30, 35);
    $pdf->SetFontSize(8);
    $where = array('idformato' => $idformato);
    $query = $CI->db->get_where('6_datos_pareja', $where, 1);
    $codigo_6 = $query->row();


    $where = array('idformato' => $idformato);
    $query = $CI->db->get_where('formatos', $where, 1);
    $codigo = $query->row();

    //View tipos sector 6. Datos de la pareja
    $where = array('idformato' => $idformato);
    $CI->db->select('tipos_sector.nombre as nombre');
    $CI->db->from('6_datos_pareja');
    $CI->db->join('tipos_sector', '6_datos_pareja.sector=tipos_sector.idtipo_sector');
    $CI->db->where($where);;
    $query = $CI->db->get();
    $view_tipos6_I = $query->row();

   // 6. datos de la pareja
    $pdf->setSourceFile('plantillas/Pareja_6.pdf');
    $pdf->AddPage();
    $tplIdx = $pdf->importPage(1);
    $pdf->useTemplate($tplIdx, 0, 0);

    if ($codigo_6->ninguno == '1') {
        $logo = SERVIDOR . APP . 'application/images/check2.png';
        $pdf->Image($logo, 197, 25.3, 4, 4);
    }

    if ($codigo->tipo_formato == 1) {
        $pdf->SetFont('Arial', 'B', 10);
        $pdf->SetTextColor(255, 255, 255);
        $pdf->SetFillColor(122, 70, 100);
        $pdf->SetY(18);
        $pdf->SetX(175);
        $pdf->MultiCell(27, 6, utf8_decode('  '), 0, 0, true);
        $pdf->SetTextColor(0, 0, 0);
    } else {
        if ($codigo_6->ninguno == '2') {
            $logo = SERVIDOR . APP . 'application/images/check2.png';
            $pdf->Image($logo, 196.8, 18.7, 4, 4);
        }
    }

    $pdf->SetFont('Arial', 'B', 8);
    if ($codigo_6->mexico_extranjero == 'EN EL EXTRANJERO') {
        $pdf->Text(149, 97.5, 'CIUDAD/LOCALIDAD');
        $pdf->Text(33, 106.5, 'ESTADO/PROVINCIA');
        $pdf->Text(107, 106.5, utf8_decode('PAÍS'));
    } else {
        $pdf->Text(149, 97.5, 'COLONIA/LOCALIDAD');
        $pdf->Text(33, 106.5, utf8_decode('MUNICIPIO/ALCALDÍA'));
        $pdf->Text(107, 106.5, utf8_decode('ENTIDAD FEDERATIVA'));
    }
    $pdf->SetFont('Arial', '', 8);
    $pdf->SetY(49);
    $pdf->SetX(13);
    $pdf->Cell(46, 4, utf8_decode($codigo_6->nombre));
    $pdf->Cell(46, 4, utf8_decode($codigo_6->primer_apellido));
    $pdf->Cell(46, 4, utf8_decode($codigo_6->segundo_apellido));
    $pdf->Cell(46, 4, utf8_decode($codigo_6->fecha_nacimiento));
    $pdf->Ln(13);
    $pdf->SetX(13);
    $pdf->Cell(35, 4, utf8_decode($codigo_6->rfc));
    $pdf->Cell(79, 4, utf8_decode($codigo_6->relacion_declarante));
    $pdf->Cell(29, 4, utf8_decode($codigo_6->ciudadano_extranjero));
    $pdf->Cell(41, 4, utf8_decode($codigo_6->curp));
    $pdf->Ln(5);
    $pdf->SetX(163);
    $pdf->Cell(34, 4, utf8_decode($codigo_6->habita_domicilio));
    $pdf->Ln(4);
    $pdf->SetX(13);
    $pdf->Cell(40, 4, utf8_decode($codigo_6->dependiente_economico));
    $pdf->SetX(105);
    $pdf->Cell(50, 4, utf8_decode($codigo_6->lugar_residencia));

    $pdf->Ln(15.5);
    $pdf->SetX(108);
    $pdf->Cell(92, 4, utf8_decode($codigo_6->mexico_extranjero));
    $pdf->Ln(12.5);
    $pdf->SetX(13);
    $pdf->Cell(70, 4, utf8_decode($codigo_6->calle));
    $pdf->Cell(22, 4, utf8_decode($codigo_6->numero_ext));
    $pdf->Cell(22, 4, utf8_decode($codigo_6->numero_int));
    $pdf->Cell(70, 4, utf8_decode($codigo_6->localidad));
    $pdf->Ln(9);
    $pdf->SetX(13);
    $pdf->Cell(70, 5, utf8_decode($codigo_6->municipio_estado));
    $pdf->Cell(79, 5, utf8_decode($codigo_6->entidad_pais));
    $pdf->Cell(35, 5, utf8_decode($codigo_6->codigo_postal));
    $pdf->Ln(15.5);
    $pdf->SetX(13);
    if ($codigo_6->actividad_laboral == 'OTRO / ESPECIFIQUE') {
        $pdf->Cell(62, 5, utf8_decode($codigo_6->actividad_laboral_esp));
    } else {
        $pdf->Cell(62, 5, utf8_decode($codigo_6->actividad_laboral));
    }

    $pdf->Cell(62, 5, utf8_decode($codigo_6->orden_gobierno));
    $pdf->Cell(61, 5, utf8_decode($codigo_6->ambito_publico));
    $pdf->Ln(10);
    $pdf->SetX(13);
    $pdf->Cell(92, 5, utf8_decode($codigo_6->ente_publico));
    $pdf->Cell(92, 5, utf8_decode($codigo_6->area_adscripcion));
    $pdf->Ln(10);
    $pdf->SetX(13);
    $pdf->Cell(92, 5, utf8_decode($codigo_6->cargo_publico));
    $pdf->Cell(92, 5, utf8_decode($codigo_6->funcion_principal));
    $pdf->Ln(10);
    $pdf->SetX(13);
    $pdf->Cell(92, 5, utf8_decode($codigo_6->salario_publico . ' ' . $codigo_6->salario_moneda));
    $pdf->Cell(92, 5, utf8_decode($codigo_6->fechaingreso_publico));
    $pdf->Ln(12);
    $pdf->SetX(13);
    $pdf->Cell(86, 5, utf8_decode($codigo_6->nombre_empresa));
    $pdf->Cell(51, 5, utf8_decode($codigo_6->cargo_privado));
    $pdf->Cell(47, 5, utf8_decode($codigo_6->rfc_privado));
    $pdf->Ln(11);
    $pdf->SetX(13);
    $pdf->Cell(61, 5, utf8_decode($codigo_6->fechaingreso_privado));
    if ($codigo_6->sector == '17') {
        $pdf->Cell(62, 4, utf8_decode($codigo_6->sector_esp));
    } else {
        if ($view_tipos6_I != null) {
            $pdf->Cell(62, 4, utf8_decode($view_tipos6_I->nombre));
        }
    }

    $pdf->Cell(61, 5, utf8_decode($codigo_6->salario_privado));
    $pdf->Ln(5.5);
    $pdf->SetX(163);
    $pdf->Cell(35, 5, utf8_decode($codigo_6->proveedor_contratista));
    $pdf->SetY(192);
    $pdf->SetX(13);
    $pdf->MultiCell(184, 3.5, utf8_decode($codigo_6->aclaraciones));             

}

