<?php

use setasign\Fpdi\Fpdi;

require_once APPPATH . "/third_party/fpdf/fpdf.php";
require_once APPPATH . "/third_party/fpdi/src/autoload.php";


function plantilla6ii($idformato,$pdf)
{
    $CI = &get_instance();
    $CI->load->database();
    $pdf->SetFont('Arial');
    $pdf->SetTextColor(0, 0, 0);
    $pdf->SetXY(30, 35);
    $pdf->SetFontSize(8);
    $where = array('idformato' => $idformato);
    $query = $CI->db->get_where('6_ii_beneficios', $where, 1);
    $codigo_6_ii = $query->row();

    //View tipos sector 6. Beneficios
    $where = array('idformato' => $idformato);
    $CI->db->select('tipos_sector.nombre as nombre');
    $CI->db->from('6_ii_beneficios');
    $CI->db->join('tipos_sector', '6_ii_beneficios.sector_productivo=tipos_sector.idtipo_sector');
    $CI->db->where($where);;
    $query = $CI->db->get();
    $view_tipos6 = $query->row();

    $where = array('idformato' => $idformato);
    $query = $CI->db->get_where('formatos', $where, 1);
    $codigo = $query->row();


    //II- DECLARACIÓN DE INTERESES

    /////////// II- 6. BENEFICIOS PRIVADOS
    if ($codigo_6_ii->ninguno == '1') {
        $logo = SERVIDOR . APP . 'application/images/check2.png';
        $pdf->Image($logo, 197.3, 33.5, 4, 4);
    }

    //SIN CAMBIO--SOLO PARA FORMATO MOD
    if ($codigo_6_ii->ninguno == '2') {
        $logo = SERVIDOR . APP . 'application/images/check2.png';
        $pdf->Image($logo, 197.5, 26, 4, 4);
    }
    //FORMATO INICIAL
    if ($codigo->tipo_formato == 1) {
        $pdf->SetY(25);
        $pdf->SetX(176);
        $pdf->MultiCell(27, 6, utf8_decode('   '), 0, 0, true);
    }
    //AGREGO POR LO MENOS 1
    if ($codigo_6_ii->ninguno == '0') {
        $pdf->SetFont('Arial', 'B', 9);
        $pdf->SetTextColor(255, 255, 255);
        $pdf->SetFillColor(122, 70, 100);
        $pdf->SetY(32);
        $pdf->SetX(176);
        $pdf->MultiCell(27, 6, utf8_decode('NÚMERO # 1'), 0, 0, true);
    }

    $pdf->SetFont('Arial', '', 8);
    $pdf->SetTextColor(0, 0, 0);
    $pdf->SetY(62);
    $pdf->SetX(13);
    if ($codigo_6_ii->tipo_beneficio == 'OTRO / ESPECIFIQUE') {
        $pdf->Cell(92, 4, utf8_decode($codigo_6_ii->tipo_beneficio_esp));
    } else {
        $pdf->Cell(92, 4, utf8_decode($codigo_6_ii->tipo_beneficio));
    }
    $pdf->Ln(10);
    $pdf->SetX(13);
    $pdf->Cell(92, 4, utf8_decode($codigo_6_ii->beneficiario));
    $pdf->Ln(10);
    $pdf->SetX(13);
    $pdf->Cell(50, 4, utf8_decode($codigo_6_ii->otorgante));
    $pdf->Ln(10);
    $pdf->SetX(13);
    $pdf->Cell(80, 4, utf8_decode($codigo_6_ii->nombre_otorgante));
    $pdf->Ln(10);
    $pdf->SetX(13);
    $pdf->Cell(95, 4, utf8_decode($codigo_6_ii->rfc));
    $pdf->Cell(80, 4, utf8_decode($codigo_6_ii->forma_recepcion));
    $pdf->Ln(10.5);
    $pdf->SetX(13);
    $pdf->Cell(124, 4, utf8_decode($codigo_6_ii->beneficio));
    $pdf->Ln(10);
    $pdf->SetX(13);
    $pdf->Cell(95, 4, utf8_decode($codigo_6_ii->monto_mensual));
    $pdf->Cell(80, 4, utf8_decode($codigo_6_ii->tipo_moneda));
    $pdf->Ln(9.5);
    $pdf->SetX(13);
    if ($codigo_6_ii->sector_productivo == '17') {
        $pdf->Cell(110, 4, utf8_decode($codigo_6_ii->sector_productivo_esp));
    } else {
        if ($view_tipos6 != null) {
            $pdf->Cell(110, 4, utf8_decode($view_tipos6->nombre));
        }
    }
    $pdf->SetY(141.5);
    $pdf->SetX(13);
    $pdf->MultiCell(184, 3.5, utf8_decode($codigo_6_ii->aclaraciones));

}

