<?php

use setasign\Fpdi\Fpdi;

require_once APPPATH . "/third_party/fpdf/fpdf.php";
require_once APPPATH . "/third_party/fpdi/src/autoload.php";


function plantilla5iitest($idformato,$pdf)
{
    $CI = &get_instance();
    $CI->load->database();
    $pdf->SetFont('Arial');
    $pdf->SetTextColor(0, 0, 0);
    $pdf->SetXY(30, 35);
    $pdf->SetFontSize(8);
    $where = array('idformato' => $idformato);
    $query = $CI->db->get_where('5_ii_clientes', $where, 1);
    $codigo_5_ii = $query->row();


    //View tipos sector 5. Clientes
    $where = array('idformato' => $idformato);
    $CI->db->select('tipos_sector.nombre as nombre');
    $CI->db->from('5_ii_clientes');
    $CI->db->join('tipos_sector', '5_ii_clientes.sector_productivo=tipos_sector.idtipo_sector');
    $CI->db->where($where);;
    $query = $CI->db->get();
    $view_tipos5 = $query->row();

    $where = array('idformato' => $idformato);
    $query = $CI->db->get_where('formatos', $where, 1);
    $codigo = $query->row();

    //II- DECLARACIÓN DE INTERESES
    //II- 5. CLIENTES PRINCIPALES
    if ($codigo_5_ii->ninguno == '1') {
        $logo = SERVIDOR . APP . 'application/images/check2.png';
        $pdf->Image($logo, 197.3, 26.8, 4, 4);
    }

    //SIN CAMBIO--SOLO PARA FORMATO MOD
    if ($codigo_5_ii->ninguno == '2') {
        $logo = SERVIDOR . APP . 'application/images/check2.png';
        $pdf->Image($logo, 197.5, 19.5, 4, 4);
    }
    //FORMATO INICIAL
    if ($codigo->tipo_formato == 1) {
        $pdf->SetFillColor(122, 70, 100);
        $pdf->SetY(19);
        $pdf->SetX(176);
        $pdf->MultiCell(27, 6, utf8_decode('   '), 0, 0, true);
    }
    //AGREGO POR LO MENOS 1
    if ($codigo_5_ii->ninguno == '0') {
        $pdf->SetFont('Arial', 'B', 9);
        $pdf->SetTextColor(255, 255, 255);
        $pdf->SetFillColor(122, 70, 100);
        $pdf->SetY(26);
        $pdf->SetX(176);
        $pdf->MultiCell(27, 6, utf8_decode('NÚMERO # 1'), 0, 0, true);
    }
    $pdf->SetFillColor(0, 0, 0);
    $pdf->SetTextColor(0, 0, 0);
    $pdf->SetFont('Arial', 'B', 8);
    if ($codigo_5_ii->mexico_extranjero == 'EN EL EXTRANJERO') {
        $pdf->Text(90, 142, utf8_decode('PAÍS DONDE SE LOCALIZA'));
    } else {
        $pdf->Text(90, 142, utf8_decode('ENTIDAD FEDERATIVA'));
    }
    if ($codigo_5_ii->ninguno != '1') {
    $pdf->SetFont('Arial', '', 8);
    $pdf->SetY(66);
    $pdf->SetX(13);
    $pdf->Cell(15, 4, utf8_decode($codigo_5_ii->actividad));
    $pdf->Ln(9);
    $pdf->SetX(13);

    if ($codigo_5_ii->declarante == 'DECLARANTE') {
        $pdf->Cell(95, 4, utf8_decode($codigo_5_ii->declarante));


    
    $pdf->Ln(10);
    $pdf->SetX(13);
    $pdf->Cell(88, 4, utf8_decode($codigo_5_ii->nombre_empresa));
    $pdf->Ln(10.5);
    $pdf->SetX(13);
    $pdf->Cell(95, 4, utf8_decode($codigo_5_ii->rfc_empresa));
    $pdf->Cell(80, 4, utf8_decode($codigo_5_ii->cliente_principal));
    $pdf->Ln(10);
    $pdf->SetX(13);
    if ($codigo_5_ii->cliente_principal == 'PERSONA FÍSICA') {
        $pdf->Cell(190, 4, utf8_decode($codigo_5_ii->razon_social), 0, 0, '', true);
        $pdf->Ln(5);
        $pdf->SetX(108);
        $pdf->Cell(95, 4, utf8_decode($codigo_5_ii->rfc_razon), 0, 0, '', true);
    }else{
        $pdf->Cell(122, 4, utf8_decode($codigo_5_ii->razon_social));
        $pdf->Ln(5);
        $pdf->SetX(108);
        $pdf->Cell(62, 4, utf8_decode($codigo_5_ii->rfc_razon));
    }

    
    $pdf->Ln(10);
    $pdf->SetX(13);
    if ($codigo_5_ii->sector_productivo == '17') {
        $pdf->Cell(95, 4, utf8_decode($codigo_5_ii->sector_productivo_esp));
    } else {
        // $pdf->Cell(95, 4, utf8_decode($codigo_5_ii->sector_productivo));
        if ($view_tipos5 != null) {
            $pdf->Cell(95, 4, utf8_decode($view_tipos5->nombre));
        }
    }
    $pdf->Ln(9.5);
    $pdf->SetX(13);
    $pdf->Cell(20, 4, utf8_decode($codigo_5_ii->monto_mensual));
    $pdf->Ln(5);
    $pdf->SetX(105);
    $pdf->Cell(92, 4, utf8_decode($codigo_5_ii->mexico_extranjero));
    $pdf->Ln(9);
    $pdf->SetX(13);
    $pdf->Cell(92, 4, utf8_decode($codigo_5_ii->entidad_pais));
    $pdf->SetY(154);
    $pdf->SetX(13);
    $pdf->MultiCell(190, 3.5, utf8_decode($codigo_5_ii->aclaraciones), 0, '', true);


    //---------------------------------------------------------------------------------------
    } else {
        $pdf->Cell(95, 4, utf8_decode($codigo_5_ii->declarante), 0, 0, '', true);


        $pdf->Ln(10);
        $pdf->SetX(13);
        $pdf->Cell(190, 4, utf8_decode($codigo_5_ii->nombre_empresa), 0, 0, '', true);
        $pdf->Ln(10.5);
        $pdf->SetX(13);
        $pdf->Cell(95, 4, utf8_decode($codigo_5_ii->rfc_empresa), 0, 0, '', true);
        $pdf->Cell(95, 4, utf8_decode($codigo_5_ii->cliente_principal), 0, 0, '', true);
        $pdf->Ln(10);
        $pdf->SetX(13);
        $pdf->Cell(190, 4, utf8_decode($codigo_5_ii->razon_social), 0, 0, '', true);
        $pdf->Ln(5);
        $pdf->SetX(108);
        $pdf->Cell(95, 4, utf8_decode($codigo_5_ii->rfc_razon), 0, 0, '', true);
        $pdf->Ln(10);
        $pdf->SetX(13);
        if ($codigo_5_ii->sector_productivo == '17') {
            $pdf->Cell(190, 4, utf8_decode($codigo_5_ii->sector_productivo_esp), 0, 0, '', true);
        } else {
            // $pdf->Cell(95, 4, utf8_decode($codigo_5_ii->sector_productivo));
            if ($view_tipos5 != null) {
                $pdf->Cell(190, 4, utf8_decode($view_tipos5->nombre), 0, 0, '', true);
            }
        }
        $pdf->Ln(9.5);
        $pdf->SetX(13);
        $pdf->Cell(190, 4, utf8_decode($codigo_5_ii->monto_mensual), 0, 0, '', true);
        $pdf->Ln(4.5);
        $pdf->SetX(105);
        $pdf->Cell(97, 4, utf8_decode($codigo_5_ii->mexico_extranjero), 0, 0, '', true);
        $pdf->Ln(9);
        $pdf->SetX(13);
        $pdf->Cell(190, 4, utf8_decode($codigo_5_ii->entidad_pais), 0, 0, '', true);
        $pdf->SetY(153.5);
        $pdf->SetX(13);
        $pdf->MultiCell(190, 3.5, utf8_decode($codigo_5_ii->aclaraciones), 0, '', true);
    }



    }

    ///---------------------------------------ADIOCIONALES--------------------------------

    $pdf->SetTextColor(0, 0, 0);
    $pdf->SetXY(30, 35);
    $pdf->SetFontSize(8);
    $y = 1;
    $where = array('idformato' => $idformato);
    $query7 = $CI->db->get_where('5_ii_clientes_add', $where, 1);
    $codigo_5ii_add = $query7->row();
    $pdf->SetTextColor(0, 0, 0);

    $CI->db->select('*')->from('5_ii_clientes_add')->where('idformato', $idformato)->where('activo', 1);
    $consulta = $CI->db->get()->result_array();
    $lenght = count($consulta) - 1;

    for ($x = 0; $x <= $lenght; $x++) {
        $datos = array(
            $id = $consulta[$x]['idcliente'],
            'idcliente' => $consulta[$x]['idcliente'],
            'actividad' => $consulta[$x]['actividad'],
            'declarante' => $consulta[$x]['declarante'],
            'nombre_empresa' => $consulta[$x]['nombre_empresa'],
            'rfc_empresa' => $consulta[$x]['rfc_empresa'],
            'cliente_principal' => $consulta[$x]['cliente_principal'],
            'razon_social' => $consulta[$x]['razon_social'],
            'rfc_razon' => $consulta[$x]['rfc_razon'],
            'sector_productivo' => $consulta[$x]['sector_productivo'],
            'sector_productivo_esp' => $consulta[$x]['sector_productivo_esp'],
            'monto_mensual' => $consulta[$x]['monto_mensual'],
            'mexico_extranjero' => $consulta[$x]['mexico_extranjero'],
            'entidad_pais' => $consulta[$x]['entidad_pais'],
            'aclaraciones' => $consulta[$x]['aclaraciones'],

        );
        $where = array('idformato' => $idformato, 'idcliente' => $id);
        $CI->db->select('tipos_sector.nombre as nombre');
        $CI->db->from('5_ii_clientes_add');
        $CI->db->join('tipos_sector', '5_ii_clientes_add.sector_productivo=tipos_sector.idtipo_sector');
        $CI->db->where($where);;
        $query = $CI->db->get();
        $view_tipos5 = $query->row();

        $y++;
        if ($codigo_5ii_add->idformato == $idformato) {

            $pdf->setSourceFile('plantillas/II_Declaracion_Intereses/II_5_Clientes.pdf');
            $pdf->AddPage();
            $tplIdx = $pdf->importPage(1);
            $pdf->useTemplate($tplIdx, 0, 0);

            $pdf->SetFont('Arial', 'B', 9);
            $pdf->SetTextColor(255, 255, 255);
            $pdf->SetFillColor(122, 70, 100);
            $pdf->SetY(19);
            $pdf->SetX(176);
            $pdf->MultiCell(27, 6, utf8_decode('   '), 0, 0, true);
            $pdf->SetY(26);
            $pdf->SetX(176);
            $pdf->MultiCell(26, 6, utf8_decode('NÚMERO # ' . $y), 0, 0, true);
            $pdf->SetTextColor(0, 0, 0);


            $pdf->SetFont('Arial', 'B', 8);
            if ($datos["mexico_extranjero"] == 'EN EL EXTRANJERO') {
                $pdf->Text(90, 142, utf8_decode('PAÍS DONDE SE LOCALIZA'));
            } else {
                $pdf->Text(90, 142, utf8_decode('ENTIDAD FEDERATIVA'));
            }
            $pdf->SetFillColor(0, 0, 0);
            $pdf->SetFont('Arial', '', 8);
            $pdf->SetY(66);
            $pdf->SetX(13);
            $pdf->Cell(15, 4, utf8_decode($datos["actividad"]));
            $pdf->Ln(9);
            $pdf->SetX(13);


            if ($datos["declarante"] == 'DECLARANTE') {
                $pdf->Cell(95, 4, utf8_decode($datos["declarante"]));
            

            $pdf->Ln(10);
            $pdf->SetX(13);
            $pdf->Cell(88, 4, utf8_decode($datos["nombre_empresa"]));
            $pdf->Ln(10.5);
            $pdf->SetX(13);
            $pdf->Cell(95, 4, utf8_decode($datos["rfc_empresa"]));
            $pdf->Cell(80, 4, utf8_decode($datos["cliente_principal"]));
            $pdf->Ln(10);
            $pdf->SetX(13);


            if ($datos["cliente_principal"] == 'PERSONA FÍSICA') {
                $pdf->Cell(190, 4, utf8_decode($datos["razon_social"]), 0, 0, '', true);
                $pdf->Ln(5);
                $pdf->SetX(108);
                $pdf->Cell(95, 4, utf8_decode($datos["rfc_razon"]), 0, 0, '', true);
            }else{
                $pdf->Cell(122, 4, utf8_decode($datos["razon_social"]));
                $pdf->Ln(5);
                $pdf->SetX(108);
                $pdf->Cell(62, 4, utf8_decode($datos["rfc_razon"]));
            }

           
            $pdf->Ln(10);
            $pdf->SetX(13);
            if ($datos["sector_productivo"] == '17') {
                $pdf->Cell(95, 4, utf8_decode($datos["sector_productivo_esp"]));
            } else {
                // $pdf->Cell(95, 4, utf8_decode($codigo_5_ii->sector_productivo));
                if ($view_tipos5 != null) {
                    $pdf->Cell(95, 4, utf8_decode($view_tipos5->nombre));
                }
            }
            $pdf->Ln(9.5);
            $pdf->SetX(13);
            $pdf->Cell(20, 4, utf8_decode($datos["monto_mensual"]));
            $pdf->Ln(5);
            $pdf->SetX(105);
            $pdf->Cell(92, 4, utf8_decode($datos["mexico_extranjero"]));
            $pdf->Ln(9);
            $pdf->SetX(13);
            $pdf->Cell(92, 4, utf8_decode($datos["entidad_pais"]));
            $pdf->SetY(154);
            $pdf->SetX(13);
            $pdf->MultiCell(190, 3.5, utf8_decode($datos["aclaraciones"]), 0, '', true);


            //--------------------------------------------------------
            } else {
                $pdf->Cell(95, 4, utf8_decode($datos["declarante"]), 0, 0, '', true);

                $pdf->Ln(10);
                $pdf->SetX(13);
                $pdf->Cell(190, 4, utf8_decode($datos["nombre_empresa"]), 0, 0, '', true);
                $pdf->Ln(10.5);
                $pdf->SetX(13);
                $pdf->Cell(95, 4, utf8_decode($datos["rfc_empresa"]), 0, 0, '', true);
                $pdf->Cell(95, 4, utf8_decode($datos["cliente_principal"]), 0, 0, '', true);
                $pdf->Ln(10);
                $pdf->SetX(13);
                $pdf->Cell(190, 4, utf8_decode($datos["razon_social"]), 0, 0, '', true);
                $pdf->Ln(5);
                $pdf->SetX(108);
                $pdf->Cell(95, 4, utf8_decode($datos["rfc_razon"]), 0, 0, '', true);
                $pdf->Ln(10);
                $pdf->SetX(13);
                if ($datos["sector_productivo"] == '17') {
                    $pdf->Cell(190, 4, utf8_decode($datos["sector_productivo_esp"]), 0, 0, '', true);
                } else {
                    if ($view_tipos5 != null) {
                        $pdf->Cell(190, 4, utf8_decode($view_tipos5->nombre), 0, 0, '', true);
                    }
                }
                $pdf->Ln(9.5);
                $pdf->SetX(13);
                $pdf->Cell(190, 4, utf8_decode($datos["monto_mensual"]), 0, 0, '', true);
                $pdf->Ln(4.5);
                $pdf->SetX(105);
                $pdf->Cell(97, 4, utf8_decode($datos["mexico_extranjero"]), 0, 0, '', true);
                $pdf->Ln(9);
                $pdf->SetX(13);
                $pdf->Cell(190, 4, utf8_decode($datos["entidad_pais"]), 0, 0, '', true);
                $pdf->SetY(154);
                $pdf->SetX(13);
                $pdf->MultiCell(190, 3.5, utf8_decode($datos["aclaraciones"]), 0, '', true);
            }
        }
    }


}

