<?php

class Datos10_model extends CI_Model
{
    public function __construct()
    {
        parent::__construct();
        $this->load->database();
    }

//  I. DECLARACIÓN DE SITUACIÓN PATRIMONIAL INICIAL
//DATOS-10. VEHÍCULOS

    public function agregar10($datos)
    {
        $idformato = $datos['idformato'];
        $data = array(

            'tipo_vehiculo' => $datos['tipo_vehiculo'],
            'tipo_vehiculo_esp' => $datos['tipo_vehiculo_esp'],
            'titular_vehiculo' => $datos['titular_vehiculo'],
            'tercero' => $datos['tercero'],
            'nombre_tercero' => $datos['nombre_tercero'],
            'rfc_tercero' => $datos['rfc_tercero'],
            'forma_adquisicion' => $datos['forma_adquisicion'],
            'forma_pago' => $datos['forma_pago'],
            'transmisor' => $datos['transmisor'],
            'nombre_transmisor' => $datos['nombre_transmisor'],
            'rfc_transmisor' => $datos['rfc_transmisor'],
            'relacion_transmisor' => $datos['relacion_transmisor'],
            'relacion_transmisor_esp' => $datos['relacion_transmisor_esp'],
            'marca' => $datos['marca'],
            'modelo' => $datos['modelo'],
            'anio' => $datos['anio'],
            'numero_serie' => $datos['numero_serie'],
            //Domicilio
            'mexico_extranjero' =>  $datos['mexico_extranjero'],
            'entidad_federativa_pais' => $datos['entidad_federativa_pais'],
            //'pais' => $datos['pais'],
            'valor_adquisicion' => $datos['valor_adquisicion'],
            'tipo_moneda' => $datos['tipo_moneda'],
            'fecha_adquisicion' => $datos['fecha_adquisicion'],

            'motivo_baja' => $datos['motivo_baja'],
            'motivo_baja_esp' => $datos['motivo_baja_esp'],
            'ninguno' => $datos['ninguno'], 
            'aclaraciones' => $datos['aclaraciones'],

            'progreso' => 5,
        );

        if ($idformato > 0) {
            $this->db->where('idformato', $idformato);
            $this->db->update('10_vehiculos', $data);
            $id = $idformato;
        } else {
            $this->db->insert('10_vehiculos', $data);
            $id = $this->db->insert_id();
        }

        if ($this->db->trans_status() === false) {
            $this->db->trans_rollback();
            $respuesta = array(
                'mensaje' => 'Error en inserción.',
                'error' => $this->db->error(),
                'status' => 409,
            );
        } else {
            $this->db->trans_commit();
            $respuesta = array(
                'mensaje' => 'Inserción correcta',
                'status' => 200,
            );
        }
        return $respuesta;
    }


    public function obtener10()
    {
        $idformato = $this->uri->segment(3);
        $where =  array('idformato' => $idformato);
        $query = $this->db->select("*")->get_where('10_vehiculos', $where);

        if ($query && $query->num_rows() >= 1) {
            $data = $query->row();
            //VAR---'registro' => $data, -- no cambiar
            $respuesta = array(
                'mensaje' => 'Registros cargado correctamente',
                'registro' => $data,
                'status' => 200,
            );
        } else {
            $respuesta = array(
                'mensaje' => 'Error al cargar registros',
                 $this->db->last_query(),
                'status' => 400,
            );
        }
        return $respuesta;
    }


    public function obtenerTiposDeclarante()
    {
        $this->db->select('*')->from('tipos_declarante');
        $publicidad = $this->db->get()->result_array();

        $respuesta = array(
            'respuesta' => $publicidad,
            'status' => REST_Controller::HTTP_OK
        );

        return $respuesta;
    }

    public function obtenerTiposRelacion()
    {
        $this->db->select('*')->from('tipos_relacion');
        $relacion = $this->db->get()->result_array();
        $respuesta = array(
            'respuesta' => $relacion,
            'status' => REST_Controller::HTTP_OK
        );
        return $respuesta;
    }






    public function obtener_add($idformato, $idvehiculo)
    {
        $where =  array(
            'idformato' => $idformato,
            'idvehiculo' => $idvehiculo
        );

        $query = $this->db->select("*")->get_where('10_vehiculos_add', $where);
        if ($query && $query->num_rows() >= 1) {
            $data = $query->row();
            $respuesta = array(
                'mensaje' => 'Registros cargado correctamente',
                $this->db->last_query(),
                'registro' => $data,
                'status' => 200,
            );
        } else {
            $respuesta = array(
                'mensaje' => 'Error al cargar registros',
                $this->db->last_query(),
                'status' => 400,
            );
        }
        return $respuesta;
    }

    public function obtener10_add()
    {

        $idformato = $this->uri->segment(3);
        $where =  array('idformato' => $idformato, 'activo' => 1);
        $query = $this->db->select("*")->get_where('10_vehiculos_add', $where);

        if ($query && $query->num_rows() >= 1) {
            $data = $query->result_array();
            //VAR---'registro' => $data, -- no cambiar
            $respuesta = array(
                'mensaje' => 'Registros cargado correctamente',
                'registro' => $data,
                $this->db->last_query(),
                'status' => 200,
            );
        } else {
            $data = 'NA';
            $respuesta = array(
                'mensaje' => 'Error al cargar registros',
                'registro' => $data,
                $this->db->last_query(),
                'status' => 200,
            );
        }
        return $respuesta;
    }

    public function agregar10_add($datos)
    {
        $idformato = $datos['idformato'];
        $idvehiculo = $datos['idvehiculo'];
        $data = array(
            'idformato' => $datos['idformato'],
            'tipo_vehiculo' => $datos['tipo_vehiculo'],
            'tipo_vehiculo_esp' => $datos['tipo_vehiculo_esp'],
            'titular_vehiculo' => $datos['titular_vehiculo'],
            'tercero' => $datos['tercero'],
            'nombre_tercero' => $datos['nombre_tercero'],
            'rfc_tercero' => $datos['rfc_tercero'],
            'forma_adquisicion' => $datos['forma_adquisicion'],
            'forma_pago' => $datos['forma_pago'],
            'transmisor' => $datos['transmisor'],
            'nombre_transmisor' => $datos['nombre_transmisor'],
            'rfc_transmisor' => $datos['rfc_transmisor'],
            'relacion_transmisor' => $datos['relacion_transmisor'],
            'relacion_transmisor_esp' => $datos['relacion_transmisor_esp'],
            'marca' => $datos['marca'],
            'modelo' => $datos['modelo'],
            'anio' => $datos['anio'],
            'numero_serie' => $datos['numero_serie'],
            'mexico_extranjero' =>  $datos['mexico_extranjero'],
            'entidad_federativa_pais' => $datos['entidad_federativa_pais'],
            'valor_adquisicion' => $datos['valor_adquisicion'],
            'tipo_moneda' => $datos['tipo_moneda'],
            'fecha_adquisicion' => $datos['fecha_adquisicion'],
            'motivo_baja' => $datos['motivo_baja'],
            'motivo_baja_esp' => $datos['motivo_baja_esp'],
            'ninguno' => $datos['ninguno'],
            'aclaraciones' => $datos['aclaraciones'],
            'activo' =>  1,

        );
        if ($idvehiculo > 0) {
            $this->db->where('idvehiculo', $idvehiculo);
            $this->db->update('10_vehiculos_add', $data);
            $id = $idformato;
        } else {

            $this->db->insert('10_vehiculos_add', $data);
            $id = $this->db->insert_id();
        }

        if ($this->db->trans_status() === false) {
            $this->db->trans_rollback();
            $respuesta = array(
                'mensaje' => 'Error en inserción.',
                'error' => $this->db->error(),
                'status' => 409,
            );
        } else {
            $this->db->trans_commit();
            $respuesta = array(
                'mensaje' => 'Inserción correcta',
                'status' => 200,
            );
        }
        return $respuesta;
    }

    public function bajaVehiculo($datos)
    {
        $idvehiculo = $datos['idvehiculo'];

        $data = array(
            'activo' => 0,
        );
        if ($idvehiculo > 0) {

            $this->db->where('idvehiculo', $idvehiculo);
            $this->db->update('10_vehiculos_add', $data);
            //   $id = $idformato;
        }

        if ($this->db->trans_status() === false) {
            $this->db->trans_rollback();
            $respuesta = array(
                'mensaje' => 'Error en inserción.',
                'error' => $this->db->error(),
                'status' => 409,
            );
        } else {
            $this->db->trans_commit();
            $respuesta = array(
                'mensaje' => 'Inserción correcta',
                'status' => 200,
            );
        }
        return $respuesta;
    }

  
}
