<?php

class Datos11_model extends CI_Model
{
    public function __construct()
    {
        parent::__construct();
        $this->load->database();
    }

//  I. DECLARACIÓN DE SITUACIÓN PATRIMONIAL INICIAL
//DATOS-11. 

    public function agregar11($datos)
    {
        $idformato = $datos['idformato'];
        $data = array(

            'tipo_bien' => $datos['tipo_bien'],
            'tipo_bien_esp' => $datos['tipo_bien_esp'],
            'titular_bien' => $datos['titular_bien'],
            'tercero' => $datos['tercero'],
            'nombre_tercero' => $datos['nombre_tercero'],
            'rfc_tercero' => $datos['rfc_tercero'],
            'descripcion_bien' => $datos['descripcion_bien'],
            'forma_adquisicion' => $datos['forma_adquisicion'],
            'forma_pago' => $datos['forma_pago'],
            'transmisor' => $datos['transmisor'],
            'nombre_transmisor' => $datos['nombre_transmisor'],
            'rfc_transmisor' => $datos['rfc_transmisor'],
            'relacion_transmisor' => $datos['relacion_transmisor'],
            'relacion_transmisor_esp' => $datos['relacion_transmisor_esp'],
            'valor_adquisicion' => $datos['valor_adquisicion'],
            'tipo_moneda' => $datos['tipo_moneda'],
            'fecha_adquisicion' => $datos['fecha_adquisicion'],

            'motivo_baja' => $datos['motivo_baja'],
            'motivo_baja_esp' => $datos['motivo_baja_esp'],
            'ninguno' => $datos['ninguno'], 
            'aclaraciones' => $datos['aclaraciones'],

            'progreso' => 5,
        );

        if ($idformato > 0) {
            $this->db->where('idformato', $idformato);
            $this->db->update('11_bienes_muebles', $data);
            $id = $idformato;
        } else {
            $this->db->insert('11_bienes_muebles', $data);
            $id = $this->db->insert_id();
        }

        if ($this->db->trans_status() === false) {
            $this->db->trans_rollback();
            $respuesta = array(
                'mensaje' => 'Error en inserción.',
                'error' => $this->db->error(),
                'status' => 409,
            );
        } else {
            $this->db->trans_commit();
            $respuesta = array(
                'mensaje' => 'Inserción correcta',
                'status' => 200,
            );
        }
        return $respuesta;
    }


    public function obtener11()
    {
        $idformato = $this->uri->segment(3);
        $where =  array('idformato' => $idformato);
        $query = $this->db->select("*")->get_where('11_bienes_muebles', $where);

        if ($query && $query->num_rows() >= 1) {
            $data = $query->row();
            //VAR---'registro' => $data, -- no cambiar
            $respuesta = array(
                'mensaje' => 'Registros cargado correctamente',
                'registro' => $data,
                'status' => 200,
            );
        } else {
            $respuesta = array(
                'mensaje' => 'Error al cargar registros',
                 $this->db->last_query(),
                'status' => 400,
            );
        }
        return $respuesta;
    }

    public function obtenerTiposDeclarante()
    {
        $this->db->select('*')->from('tipos_declarante');
        $publicidad = $this->db->get()->result_array();

        $respuesta = array(
            'respuesta' => $publicidad,
            'status' => REST_Controller::HTTP_OK
        );

        return $respuesta;
    }

    public function obtenerTiposRelacion()
    {
        $this->db->select('*')->from('tipos_relacion');
        $relacion = $this->db->get()->result_array();
        $respuesta = array(
            'respuesta' => $relacion,
            'status' => REST_Controller::HTTP_OK
        );
        return $respuesta;
    }




    public function obtener_add($idformato, $idmueble)
    {
        $where =  array(
            'idformato' => $idformato,
            'idmueble' => $idmueble
        );

        $query = $this->db->select("*")->get_where('11_bienes_muebles_add', $where);
        if ($query && $query->num_rows() >= 1) {
            $data = $query->row();
            $respuesta = array(
                'mensaje' => 'Registros cargado correctamente',
                $this->db->last_query(),
                'registro' => $data,
                'status' => 200,
            );
        } else {
            $respuesta = array(
                'mensaje' => 'Error al cargar registros',
                $this->db->last_query(),
                'status' => 400,
            );
        }
        return $respuesta;
    }

    public function obtener11_add()
    {

        $idformato = $this->uri->segment(3);
        $where =  array('idformato' => $idformato, 'activo' => 1);
        $query = $this->db->select("*")->get_where('11_bienes_muebles_add', $where);

        if ($query && $query->num_rows() >= 1) {
            $data = $query->result_array();
            //VAR---'registro' => $data, -- no cambiar
            $respuesta = array(
                'mensaje' => 'Registros cargado correctamente',
                'registro' => $data,
                $this->db->last_query(),
                'status' => 200,
            );
        } else {
            $data = 'NA';
            $respuesta = array(
                'mensaje' => 'Error al cargar registros',
                'registro' => $data,
                $this->db->last_query(),
                'status' => 200,
            );
        }
        return $respuesta;
    }

    public function agregar11_add($datos)
    {
        $idformato = $datos['idformato'];
        $idmueble = $datos['idmueble'];
        $data = array(
            'idformato' => $datos['idformato'],
            'tipo_bien' => $datos['tipo_bien'],
            'tipo_bien_esp' => $datos['tipo_bien_esp'],
            'titular_bien' => $datos['titular_bien'],
            'tercero' => $datos['tercero'],
            'nombre_tercero' => $datos['nombre_tercero'],
            'rfc_tercero' => $datos['rfc_tercero'],
            'descripcion_bien' => $datos['descripcion_bien'],
            'forma_adquisicion' => $datos['forma_adquisicion'],
            'forma_pago' => $datos['forma_pago'],
            'transmisor' => $datos['transmisor'],
            'nombre_transmisor' => $datos['nombre_transmisor'],
            'rfc_transmisor' => $datos['rfc_transmisor'],
            'relacion_transmisor' => $datos['relacion_transmisor'],
            'relacion_transmisor_esp' => $datos['relacion_transmisor_esp'],
            'valor_adquisicion' => $datos['valor_adquisicion'],
            'tipo_moneda' => $datos['tipo_moneda'],
            'fecha_adquisicion' => $datos['fecha_adquisicion'],

            'motivo_baja' => $datos['motivo_baja'],
            'motivo_baja_esp' => $datos['motivo_baja_esp'],
            'ninguno' => $datos['ninguno'],
            'aclaraciones' => $datos['aclaraciones'],
            'activo' =>  1,

        );
        if ($idmueble > 0) {
            $this->db->where('idmueble', $idmueble);
            $this->db->update('11_bienes_muebles_add', $data);
            $id = $idformato;
        } else {

            $this->db->insert('11_bienes_muebles_add', $data);
            $id = $this->db->insert_id();
        }

        if ($this->db->trans_status() === false) {
            $this->db->trans_rollback();
            $respuesta = array(
                'mensaje' => 'Error en inserción.',
                'error' => $this->db->error(),
                'status' => 409,
            );
        } else {
            $this->db->trans_commit();
            $respuesta = array(
                'mensaje' => 'Inserción correcta',
                'status' => 200,
            );
        }
        return $respuesta;
    }

    public function bajaInmueble($datos)
    {
        $idmueble = $datos['idmueble'];

        $data = array(
            'activo' => 0,
        );
        if ($idmueble > 0) {

            $this->db->where('idmueble', $idmueble);
            $this->db->update('11_bienes_muebles_add', $data);
            //   $id = $idformato;
        }

        if ($this->db->trans_status() === false) {
            $this->db->trans_rollback();
            $respuesta = array(
                'mensaje' => 'Error en inserción.',
                'error' => $this->db->error(),
                'status' => 409,
            );
        } else {
            $this->db->trans_commit();
            $respuesta = array(
                'mensaje' => 'Inserción correcta',
                'status' => 200,
            );
        }
        return $respuesta;
    }

  
}
