<?php

class Datos13_model extends CI_Model
{
    public function __construct()
    {
        parent::__construct();
        $this->load->database();
    }

//  I. DECLARACIÓN DE SITUACIÓN PATRIMONIAL INICIAL
//DATOS-13. 

    public function agregar13($datos)
    {
        $idformato = $datos['idformato'];
        $data = array(

            'tipo_adeudo' => $datos['tipo_adeudo'],
            'tipo_adeudo_esp' => $datos['tipo_adeudo_esp'],
            'titular_adeudo' => $datos['titular_adeudo'],
            'numero_cuenta' => $datos['numero_cuenta'],
            'fecha_adquisicion' => $datos['fecha_adquisicion'],
            'monto_adeudo' => $datos['monto_adeudo'],
            'tipo_moneda' => $datos['tipo_moneda'],
            'saldo' => $datos['saldo'],
            'tercero' => $datos['tercero'],
            'nombre_tercero' => $datos['nombre_tercero'],
            'rfc_tercero' => $datos['rfc_tercero'],
            'otorgante' => $datos['otorgante'],
            'nombre_otorgante' => $datos['nombre_otorgante'],
            'rfc_otorgante' => $datos['rfc_otorgante'],
            'mexico_extranjero' => $datos['mexico_extranjero'],
            'pais' => $datos['pais'],
      
            'ninguno' => $datos['ninguno'], 
            'aclaraciones' => $datos['aclaraciones'],

            'progreso' => 5,
        );

        if ($idformato > 0) {
            $this->db->where('idformato', $idformato);
            $this->db->update('13_adeudos', $data);
            $id = $idformato;
        } else {
            $this->db->insert('13_adeudos', $data);
            $id = $this->db->insert_id();
        }

        if ($this->db->trans_status() === false) {
            $this->db->trans_rollback();
            $respuesta = array(
                'mensaje' => 'Error en inserción.',
                'error' => $this->db->error(),
                'status' => 409,
            );
        } else {
            $this->db->trans_commit();
            $respuesta = array(
                'mensaje' => 'Inserción correcta',
                'status' => 200,
            );
        }
        return $respuesta;
    }


    public function obtener13()
    {
        $idformato = $this->uri->segment(3);
        $where =  array('idformato' => $idformato);
        $query = $this->db->select("*")->get_where('13_adeudos', $where);

        if ($query && $query->num_rows() >= 1) {
            $data = $query->row();
            //VAR---'registro' => $data, -- no cambiar
            $respuesta = array(
                'mensaje' => 'Registros cargado correctamente',
                'registro' => $data,
                'status' => 200,
            );
        } else {
            $respuesta = array(
                'mensaje' => 'Error al cargar registros',
                 $this->db->last_query(),
                'status' => 400,
            );
        }
        return $respuesta;
    }

    public function obtenerTiposDeclarante()
    {
        $this->db->select('*')->from('tipos_declarante');
        $publicidad = $this->db->get()->result_array();

        $respuesta = array(
            'respuesta' => $publicidad,
            'status' => REST_Controller::HTTP_OK
        );

        return $respuesta;
    }




    public function obtener_add($idformato, $idadeudo)
    {
        $where =  array(
            'idformato' => $idformato,
            'idadeudo' => $idadeudo
        );

        $query = $this->db->select("*")->get_where('13_adeudos_add', $where);
        if ($query && $query->num_rows() >= 1) {
            $data = $query->row();
            $respuesta = array(
                'mensaje' => 'Registros cargado correctamente',
                $this->db->last_query(),
                'registro' => $data,
                'status' => 200,
            );
        } else {
            $respuesta = array(
                'mensaje' => 'Error al cargar registros',
                $this->db->last_query(),
                'status' => 400,
            );
        }
        return $respuesta;
    }

    public function obtener13_add()
    {

        $idformato = $this->uri->segment(3);
        $where =  array('idformato' => $idformato, 'activo' => 1);
        $query = $this->db->select("*")->get_where('13_adeudos_add', $where);

        if ($query && $query->num_rows() >= 1) {
            $data = $query->result_array();
            //VAR---'registro' => $data, -- no cambiar
            $respuesta = array(
                'mensaje' => 'Registros cargado correctamente',
                'registro' => $data,
                $this->db->last_query(),
                'status' => 200,
            );
        } else {
            $data = 'NA';
            $respuesta = array(
                'mensaje' => 'Error al cargar registros',
                'registro' => $data,
                $this->db->last_query(),
                'status' => 200,
            );
        }
        return $respuesta;
    }

    public function agregar13_add($datos)
    {
        $idformato = $datos['idformato'];
        $idadeudo = $datos['idadeudo'];
        $data = array(
            'idformato' => $datos['idformato'],
            'tipo_adeudo' => $datos['tipo_adeudo'],
            'tipo_adeudo_esp' => $datos['tipo_adeudo_esp'],
            'titular_adeudo' => $datos['titular_adeudo'],
            'numero_cuenta' => $datos['numero_cuenta'],
            'fecha_adquisicion' => $datos['fecha_adquisicion'],
            'monto_adeudo' => $datos['monto_adeudo'],
            'tipo_moneda' => $datos['tipo_moneda'],
            'saldo' => $datos['saldo'],
            'tercero' => $datos['tercero'],
            'nombre_tercero' => $datos['nombre_tercero'],
            'rfc_tercero' => $datos['rfc_tercero'],
            'otorgante' => $datos['otorgante'],
            'nombre_otorgante' => $datos['nombre_otorgante'],
            'rfc_otorgante' => $datos['rfc_otorgante'],
            'mexico_extranjero' => $datos['mexico_extranjero'],
            'pais' => $datos['pais'],

           // 'ninguno' => $datos['ninguno'],
            'aclaraciones' => $datos['aclaraciones'],
            'activo' =>  1,

        );
        if ($idadeudo > 0) {
            $this->db->where('idadeudo', $idadeudo);
            $this->db->update('13_adeudos_add', $data);
            $id = $idformato;
        } else {

            $this->db->insert('13_adeudos_add', $data);
            $id = $this->db->insert_id();
        }

        if ($this->db->trans_status() === false) {
            $this->db->trans_rollback();
            $respuesta = array(
                'mensaje' => 'Error en inserción.',
                'error' => $this->db->error(),
                'status' => 409,
            );
        } else {
            $this->db->trans_commit();
            $respuesta = array(
                'mensaje' => 'Inserción correcta',
                'status' => 200,
            );
        }
        return $respuesta;
    }

    public function bajaAdeudo($datos)
    {
        $idadeudo = $datos['idadeudo'];

        $data = array(
            'activo' => 0,
        );
        if ($idadeudo > 0) {

            $this->db->where('idadeudo', $idadeudo);
            $this->db->update('13_adeudos_add', $data);
            //   $id = $idformato;
        }

        if ($this->db->trans_status() === false) {
            $this->db->trans_rollback();
            $respuesta = array(
                'mensaje' => 'Error en inserción.',
                'error' => $this->db->error(),
                'status' => 409,
            );
        } else {
            $this->db->trans_commit();
            $respuesta = array(
                'mensaje' => 'Inserción correcta',
                'status' => 200,
            );
        }
        return $respuesta;
    }

  
}
