<?php

class Datos1_ii_model extends CI_Model
{
    public function __construct()
    {
        parent::__construct();
        $this->load->database();
    }

//  I. DECLARACIÓN DE SITUACIÓN PATRIMONIAL INICIAL
//DATOS-1 - I!:. 

    public function agregar1($datos)
    {
        $idformato = $datos['idformato'];
        $data = array(

            'tipo_bien' => $datos['tipo_bien'],
            'tipo_bien_esp' => $datos['tipo_bien_esp'],
            //Domicilio
            'calle' =>  $datos['calle'],
            'numero_ext' =>  $datos['numero_ext'],
            'numero_int' =>  $datos['numero_int'],
            'localidad' =>  $datos['localidad'],
            'codigo_postal' =>  $datos['codigo_postal'],
            'municipio_estado' =>  $datos['municipio_estado'],
            'entidad_pais' =>  $datos['entidad_pais'],
            'mexico_extranjero' =>  $datos['mexico_extranjero'],

            'vehiculo' => $datos['vehiculo'],
            'tipo_vehiculo' => $datos['tipo_vehiculo'],
            'tipo_vehiculo_esp' => $datos['tipo_vehiculo_esp'],
            'marca' => $datos['marca'],
            'modelo' => $datos['modelo'],
            'anio' => $datos['anio'],
            'numero_serie' => $datos['numero_serie'],
            // 'lugar_registro' => $datos['lugar_registro'],
            'mexico_extranjero2' => $datos['mexico_extranjero2'],
            'entidad_pais_registro' => $datos['entidad_pais_registro'],
            'titular' => $datos['titular'],
            'nombre_titular' => $datos['nombre_titular'],
            'rfc_titular' => $datos['rfc_titular'],
            'relacion_titular' => $datos['relacion_titular'],
            
            'ninguno' => $datos['ninguno'], 
            'aclaraciones' => $datos['aclaraciones'],
        );

        if ($idformato > 0) {
            $this->db->where('idformato', $idformato);
            $this->db->update('14_prestamos', $data);
            $id = $idformato;
        } else {
            $this->db->insert('14_prestamos', $data);
            $id = $this->db->insert_id();
        }

        if ($this->db->trans_status() === false) {
            $this->db->trans_rollback();
            $respuesta = array(
                'mensaje' => 'Error en inserción.',
                'error' => $this->db->error(),
                'status' => 409,
            );
        } else {
            $this->db->trans_commit();
            $respuesta = array(
                'mensaje' => 'Inserción correcta',
                'status' => 200,
            );
        }
        return $respuesta;
    }


    public function obtener1()
    {
        $idformato = $this->uri->segment(3);
        $where =  array('idformato' => $idformato);
        $query = $this->db->select("*")->get_where('14_prestamos', $where);

        if ($query && $query->num_rows() >= 1) {
            $data = $query->row();
            //VAR---'registro' => $data, -- no cambiar
            $respuesta = array(
                'mensaje' => 'Registros cargado correctamente',
                'registro' => $data,
                'status' => 200,
            );
        } else {
            $respuesta = array(
                'mensaje' => 'Error al cargar registros',
                 $this->db->last_query(),
                'status' => 400,
            );
        }
        return $respuesta;
    }


    //  II.- DECLARACIÓN DE INTERESES
    //DATOS-1
    public function agregar1_ii($datos)
    {
        $idformato = $datos['idformato'];
        $data = array(

            'declarante' => $datos['declarante'],
            'nombre_empresa' => $datos['nombre_empresa'],
            'rfc' => $datos['rfc'],
            'porcentaje' => $datos['porcentaje'],
            'tipo_participacion' => $datos['tipo_participacion'],
            'tipo_participacion_esp' => $datos['tipo_participacion_esp'],
            'remuneracion' => $datos['remuneracion'],
            'monto_mensual' => $datos['monto_mensual'],
            'mexico_extranjero' => $datos['mexico_extranjero'],
            'entidad_pais' => $datos['entidad_pais'],
            'sector_productivo' => $datos['sector_productivo'],
            'sector_productivo_esp' => $datos['sector_productivo_esp'],

            'ninguno' => $datos['ninguno'],
            'aclaraciones' => $datos['aclaraciones'],
            'progreso' => 5,
        );

        if ($idformato > 0) {
            $this->db->where('idformato', $idformato);
            $this->db->update('1_ii_participacion_empresas', $data);
            $id = $idformato;
        } else {
            $this->db->insert('1_ii_participacion_empresas', $data);
            $id = $this->db->insert_id();
        }

        if ($this->db->trans_status() === false) {
            $this->db->trans_rollback();
            $respuesta = array(
                'mensaje' => 'Error en inserción.',
                'error' => $this->db->error(),
                'status' => 409,
            );
        } else {
            $this->db->trans_commit();
            $respuesta = array(
                'mensaje' => 'Inserción correcta',
                'status' => 200,
            );
        }
        return $respuesta;
    }


    public function obtener1_ii()
    {
        $idformato = $this->uri->segment(3);
        $where =  array('idformato' => $idformato);
        $query = $this->db->select("*")->get_where('1_ii_participacion_empresas', $where);

        if ($query && $query->num_rows() >= 1) {
            $data = $query->row();
            //VAR---'registro' => $data, -- no cambiar
            $respuesta = array(
                'mensaje' => 'Registros cargado correctamente',
                'registro' => $data,
                'status' => 200,
            );
        } else {
            $respuesta = array(
                'mensaje' => 'Error al cargar registros',
                $this->db->last_query(),
                'status' => 400,
            );
        }
        return $respuesta;
    }

    public function obtenerTiposSector()
    {
        $this->db->select('*')->from('tipos_sector');
        $sector = $this->db->get()->result_array();

        $respuesta = array(
            'respuesta' => $sector,
            'status' => REST_Controller::HTTP_OK
        );

        return $respuesta;
    }




    public function obtener_add($idformato, $idparticipacion)
    {
        $where =  array(
            'idformato' => $idformato,
            'idparticipacion' => $idparticipacion
        );

        $query = $this->db->select("*")->get_where('1_ii_participacion_empresas_add', $where);
        if ($query && $query->num_rows() >= 1) {
            $data = $query->row();
            $respuesta = array(
                'mensaje' => 'Registros cargado correctamente',
                $this->db->last_query(),
                'registro' => $data,
                'status' => 200,
            );
        } else {
            $respuesta = array(
                'mensaje' => 'Error al cargar registros',
                $this->db->last_query(),
                'status' => 400,
            );
        }
        return $respuesta;
    }

    public function obtener1_ii_add()
    {

        $idformato = $this->uri->segment(3);
        $where =  array('idformato' => $idformato, 'activo' => 1);
        $query = $this->db->select("*")->get_where('1_ii_participacion_empresas_add', $where);

        if ($query && $query->num_rows() >= 1) {
            $data = $query->result_array();
            //VAR---'registro' => $data, -- no cambiar
            $respuesta = array(
                'mensaje' => 'Registros cargado correctamente',
                'registro' => $data,
                $this->db->last_query(),
                'status' => 200,
            );
        } else {
            $data = 'NA';
            $respuesta = array(
                'mensaje' => 'Error al cargar registros',
                'registro' => $data,
                $this->db->last_query(),
                'status' => 200,
            );
        }
        return $respuesta;
    }

    public function agregar1_ii_add($datos)
    {
        $idformato = $datos['idformato'];
        $idparticipacion = $datos['idparticipacion'];
        $data = array(
            'idformato' => $datos['idformato'],

            'declarante' => $datos['declarante'],
            'nombre_empresa' => $datos['nombre_empresa'],
            'rfc' => $datos['rfc'],
            'porcentaje' => $datos['porcentaje'],
            'tipo_participacion' => $datos['tipo_participacion'],
            'tipo_participacion_esp' => $datos['tipo_participacion_esp'],
            'remuneracion' => $datos['remuneracion'],
            'monto_mensual' => $datos['monto_mensual'],
            'mexico_extranjero' => $datos['mexico_extranjero'],
            'entidad_pais' => $datos['entidad_pais'],
            'sector_productivo' => $datos['sector_productivo'],
            'sector_productivo_esp' => $datos['sector_productivo_esp'],
            'aclaraciones' => $datos['aclaraciones'],
            'activo' =>  1,

        );
        if ($idparticipacion > 0) {
            $this->db->where('idparticipacion', $idparticipacion);
            $this->db->update('1_ii_participacion_empresas_add', $data);
            $id = $idformato;
        } else {

            $this->db->insert('1_ii_participacion_empresas_add', $data);
            $id = $this->db->insert_id();
        }

        if ($this->db->trans_status() === false) {
            $this->db->trans_rollback();
            $respuesta = array(
                'mensaje' => 'Error en inserción.',
                'error' => $this->db->error(),
                'status' => 409,
            );
        } else {
            $this->db->trans_commit();
            $respuesta = array(
                'mensaje' => 'Inserción correcta',
                'status' => 200,
            );
        }
        return $respuesta;
    }

    public function bajaPrestamo($datos)
    {
        $idparticipacion = $datos['idparticipacion'];

        $data = array(
            'activo' => 0,
        );
        if ($idparticipacion > 0) {

            $this->db->where('idparticipacion', $idparticipacion);
            $this->db->update('1_ii_participacion_empresas_add', $data);
            //   $id = $idformato;
        }

        if ($this->db->trans_status() === false) {
            $this->db->trans_rollback();
            $respuesta = array(
                'mensaje' => 'Error en inserción.',
                'error' => $this->db->error(),
                'status' => 409,
            );
        } else {
            $this->db->trans_commit();
            $respuesta = array(
                'mensaje' => 'Inserción correcta',
                'status' => 200,
            );
        }
        return $respuesta;
    }
}
