<?php

class Datos2_model extends CI_Model
{
    public function __construct()
    {
        parent::__construct();
        $this->load->database();
    }

//  I. DECLARACIÓN DE SITUACIÓN PATRIMONIAL INICIAL
//DATOS-2.  DOMICILIO DEL DECLARANTE

    public function agregar2($datos)
    {
        $idformato = $datos['idformato'];
        $data = array(
            //Domicilio
            'calle' => $datos['calle'],
            'numero_ext' => $datos['numero_ext'],
            'numero_int' => $datos['numero_int'],
            'localidad' => $datos['localidad'],
            'codigo_postal' => $datos['codigo_postal'],
            'aclaraciones' => $datos['aclaraciones'],
            'municipio_estado' => $datos['municipio_estado'],
            'entidad_pais' => $datos['entidad_pais'],
            'mexico_extranjero' => $datos['mexico_extranjero'],
            'progreso' => 5,
        );
        // $porcentaje = array(
        //     'porcentaje' => 10,
        // );

        if ($idformato > 0) {
            $this->db->where('idformato', $idformato);
            $this->db->update('2_domicilio_declarante', $data);

            // if ($datos['progreso'] < 15) {
            // $this->db->where('idformato', $idformato);
            // $this->db->update('progreso', $porcentaje);
            // }
            $id = $idformato;
        } else {
            $this->db->insert('2_domicilio_declarante', $data);
            $id = $this->db->insert_id();
        }

        if ($this->db->trans_status() === false) {
            $this->db->trans_rollback();
            $respuesta = array(
                'mensaje' => 'Error en inserción.',
                'error' => $this->db->error(),
                'status' => 409,
            );
        } else {
            $this->db->trans_commit();
            $respuesta = array(
                'mensaje' => 'Inserción correcta',
                'status' => 200,
            );
        }
        return $respuesta;
    }


    public function obtener2()
    {
        $idformato = $this->uri->segment(3);
        $where =  array('idformato' => $idformato);
        $query = $this->db->select("*")->get_where('2_domicilio_declarante', $where);

        if ($query && $query->num_rows() >= 1) {
            $data = $query->row();
            //VAR---'registro' => $data, -- no cambiar
            $respuesta = array(
                'mensaje' => 'Registros cargado correctamente',
                'registro' => $data,
                'status' => 200,
            );
        } else {
            $respuesta = array(
                'mensaje' => 'Error al cargar registros',
                 $this->db->last_query(),
                'status' => 400,
            );
        }
        return $respuesta;
    }


    //  II.- DECLARACIÓN DE INTERESES
    //DATOS-2. ¿ PARTICIPA EN LA TOMA DE DECISIONES 

    public function agregar2_ii($datos)
    {
        $idformato = $datos['idformato'];
        $data = array(

            'declarante' => $datos['declarante'],
            'nombre_institucion' => $datos['nombre_institucion'],
            'rfc' => $datos['rfc'],
            'puesto' => $datos['puesto'],
            'tipo_institucion' => $datos['tipo_institucion'],
            'tipo_institucion_esp' => $datos['tipo_institucion_esp'],
            'fecha_inicio' => $datos['fecha_inicio'],
            'remuneracion' => $datos['remuneracion'],
            'monto_mensual' => $datos['monto_mensual'],
            'mexico_extranjero' => $datos['mexico_extranjero'],
            'entidad_pais' => $datos['entidad_pais'],

            'ninguno' => $datos['ninguno'],
            'aclaraciones' => $datos['aclaraciones'],
            'progreso' => 5,
        );

        if ($idformato > 0) {
            $this->db->where('idformato', $idformato);
            $this->db->update('2_ii_toma_decisiones', $data);
            $id = $idformato;
        } else {
            $this->db->insert('2_ii_toma_decisiones', $data);
            $id = $this->db->insert_id();
        }

        if ($this->db->trans_status() === false) {
            $this->db->trans_rollback();
            $respuesta = array(
                'mensaje' => 'Error en inserción.',
                'error' => $this->db->error(),
                'status' => 409,
            );
        } else {
            $this->db->trans_commit();
            $respuesta = array(
                'mensaje' => 'Inserción correcta',
                'status' => 200,
            );
        }
        return $respuesta;
    }


    public function obtener2_ii()
    {
        $idformato = $this->uri->segment(3);
        $where =  array('idformato' => $idformato);
        $query = $this->db->select("*")->get_where('2_ii_toma_decisiones', $where);

        if ($query && $query->num_rows() >= 1) {
            $data = $query->row();
            //VAR---'registro' => $data, -- no cambiar
            $respuesta = array(
                'mensaje' => 'Registros cargado correctamente',
                'registro' => $data,
                'status' => 200,
            );
        } else {
            $respuesta = array(
                'mensaje' => 'Error al cargar registros',
                $this->db->last_query(),
                'status' => 400,
            );
        }
        return $respuesta;
    }




    public function obtener_add($idformato, $idparticipacion)
    {
        $where =  array(
            'idformato' => $idformato,
            'idparticipacion' => $idparticipacion
        );

        $query = $this->db->select("*")->get_where('2_ii_toma_decisiones_add', $where);
        if ($query && $query->num_rows() >= 1) {
            $data = $query->row();
            $respuesta = array(
                'mensaje' => 'Registros cargado correctamente',
                $this->db->last_query(),
                'registro' => $data,
                'status' => 200,
            );
        } else {
            $respuesta = array(
                'mensaje' => 'Error al cargar registros',
                $this->db->last_query(),
                'status' => 400,
            );
        }
        return $respuesta;
    }

    public function obtener2_ii_add()
    {

        $idformato = $this->uri->segment(3);
        $where =  array('idformato' => $idformato, 'activo' => 1);
        $query = $this->db->select("*")->get_where('2_ii_toma_decisiones_add', $where);

        if ($query && $query->num_rows() >= 1) {
            $data = $query->result_array();
            //VAR---'registro' => $data, -- no cambiar
            $respuesta = array(
                'mensaje' => 'Registros cargado correctamente',
                'registro' => $data,
                $this->db->last_query(),
                'status' => 200,
            );
        } else {
            $data = 'NA';
            $respuesta = array(
                'mensaje' => 'Error al cargar registros',
                'registro' => $data,
                $this->db->last_query(),
                'status' => 200,
            );
        }
        return $respuesta;
    }

    public function agregar2_ii_add($datos)
    {
        $idformato = $datos['idformato'];
        $idparticipacion = $datos['idparticipacion'];
        $data = array(
            'idformato' => $datos['idformato'],
            'declarante' => $datos['declarante'],
            'nombre_institucion' => $datos['nombre_institucion'],
            'rfc' => $datos['rfc'],
            'puesto' => $datos['puesto'],
            'tipo_institucion' => $datos['tipo_institucion'],
            'tipo_institucion_esp' => $datos['tipo_institucion_esp'],
            'fecha_inicio' => $datos['fecha_inicio'],
            'remuneracion' => $datos['remuneracion'],
            'monto_mensual' => $datos['monto_mensual'],
            'mexico_extranjero' => $datos['mexico_extranjero'],
            'entidad_pais' => $datos['entidad_pais'],
            'aclaraciones' => $datos['aclaraciones'],
            'activo' =>  1,

        );
        if ($idparticipacion > 0) {
            $this->db->where('idparticipacion', $idparticipacion);
            $this->db->update('2_ii_toma_decisiones_add', $data);
            $id = $idformato;
        } else {

            $this->db->insert('2_ii_toma_decisiones_add', $data);
            $id = $this->db->insert_id();
        }

        if ($this->db->trans_status() === false) {
            $this->db->trans_rollback();
            $respuesta = array(
                'mensaje' => 'Error en inserción.',
                'error' => $this->db->error(),
                'status' => 409,
            );
        } else {
            $this->db->trans_commit();
            $respuesta = array(
                'mensaje' => 'Inserción correcta',
                'status' => 200,
            );
        }
        return $respuesta;
    }

    public function bajaPrestamo($datos)
    {
        $idparticipacion = $datos['idparticipacion'];

        $data = array(
            'activo' => 0,
        );
        if ($idparticipacion > 0) {

            $this->db->where('idparticipacion', $idparticipacion);
            $this->db->update('2_ii_toma_decisiones_add', $data);
            //   $id = $idformato;
        }

        if ($this->db->trans_status() === false) {
            $this->db->trans_rollback();
            $respuesta = array(
                'mensaje' => 'Error en inserción.',
                'error' => $this->db->error(),
                'status' => 409,
            );
        } else {
            $this->db->trans_commit();
            $respuesta = array(
                'mensaje' => 'Inserción correcta',
                'status' => 200,
            );
        }
        return $respuesta;
    }
  
}
