<?php

class Datos5_model extends CI_Model
{
    public function __construct()
    {
        parent::__construct();
        $this->load->database();
    }

//  I. DECLARACIÓN DE SITUACIÓN PATRIMONIAL INICIAL
//DATOS-5. 

    public function agregar5($datos)
    {
        $idformato = $datos['idformato'];
        $data = array(
            
            'ambito_sector' => $datos['ambito_sector'],
            'ambito_sector_esp' => $datos['ambito_sector_esp'],
            'nivel_orden' =>  $datos['nivel_orden'],
            'ambito' =>  $datos['ambito'],
            'ente_publico' => $datos['ente_publico'],
            'rfc' => $datos['rfc'],
            'area_adscripcion' => $datos['area_adscripcion'],
            'empleo' => $datos['empleo'],
            'funcion_principal' => $datos['funcion_principal'],
            'sector' => $datos['sector'],
            'sector_esp' => $datos['sector_esp'],
            'fecha_ingreso' => $datos['fecha_ingreso'],
            'fecha_egreso' => $datos['fecha_egreso'],
            'lugar' => $datos['lugar'],
            'aclaraciones' => $datos['aclaraciones'],

            'ninguno' => $datos['ninguno'],
            'progreso' => 5,
        );

        // $porcentaje = array(
        //     'porcentaje' => 25,
        // );

        if ($idformato > 0) {
            $this->db->where('idformato', $idformato);
            $this->db->update('5_experiencia_laboral', $data);
            $id = $idformato;

            // if ($datos['progreso'] < 30) {
            //     $this->db->where('idformato', $idformato);
            //     $this->db->update('progreso', $porcentaje);
            // }
        } else {
            $this->db->insert('5_experiencia_laboral', $data);
            $id = $this->db->insert_id();
        }

        if ($this->db->trans_status() === false) {
            $this->db->trans_rollback();
            $respuesta = array(
                'mensaje' => 'Error en inserción.',
                'error' => $this->db->error(),
                'status' => 409,
            );
        } else {
            $this->db->trans_commit();
            $respuesta = array(
                'mensaje' => 'Inserción correcta',
                'status' => 200,
            );
        }
        return $respuesta;
    }


    public function obtener5()
    {
        $idformato = $this->uri->segment(3);
        $where =  array('idformato' => $idformato);
        $query = $this->db->select("*")->get_where('5_experiencia_laboral', $where);

        if ($query && $query->num_rows() >= 1) {
            $data = $query->row();
            //VAR---'registro' => $data, -- no cambiar
            $respuesta = array(
                'mensaje' => 'Registros cargado correctamente',
                'registro' => $data,
                'status' => 200,
            );
        } else {
            $respuesta = array(
                'mensaje' => 'Error al cargar registros',
                 $this->db->last_query(),
                'status' => 400,
            );
        }
        return $respuesta;
    }


    //  II.- DECLARACIÓN DE INTERESES
    //DATOS-5
    
    public function agregar5_ii($datos)
    {
        $idformato = $datos['idformato'];
        $data = array(
            'actividad' => $datos['actividad'],
            'declarante' => $datos['declarante'],
            'nombre_empresa' => $datos['nombre_empresa'],
            'rfc_empresa' => $datos['rfc_empresa'],
            'cliente_principal' => $datos['cliente_principal'],
            'razon_social' => $datos['razon_social'],
            'rfc_razon' => $datos['rfc_razon'],
            'sector_productivo' => $datos['sector_productivo'],
            'sector_productivo_esp' => $datos['sector_productivo_esp'],
            'monto_mensual' => $datos['monto_mensual'],
            'mexico_extranjero' => $datos['mexico_extranjero'],
            'entidad_pais' => $datos['entidad_pais'],
            
            'ninguno' => $datos['ninguno'],
            'aclaraciones' => $datos['aclaraciones'],

            'progreso' => 5,
        );

        if ($idformato > 0) {
            $this->db->where('idformato', $idformato);
            $this->db->update('5_ii_clientes', $data);
            $id = $idformato;
        } else {
            $this->db->insert('5_ii_clientes', $data);
            $id = $this->db->insert_id();
        }

        if ($this->db->trans_status() === false) {
            $this->db->trans_rollback();
            $respuesta = array(
                'mensaje' => 'Error en inserción.',
                'error' => $this->db->error(),
                'status' => 409,
            );
        } else {
            $this->db->trans_commit();
            $respuesta = array(
                'mensaje' => 'Inserción correcta',
                'status' => 200,
            );
        }
        return $respuesta;
    }


    public function obtener5_ii()
    {
        $idformato = $this->uri->segment(3);
        $where =  array('idformato' => $idformato);
        $query = $this->db->select("*")->get_where('5_ii_clientes', $where);

        if ($query && $query->num_rows() >= 1) {
            $data = $query->row();
            //VAR---'registro' => $data, -- no cambiar
            $respuesta = array(
                'mensaje' => 'Registros cargado correctamente',
                'registro' => $data,
                'status' => 200,
            );
        } else {
            $respuesta = array(
                'mensaje' => 'Error al cargar registros',
                $this->db->last_query(),
                'status' => 400,
            );
        }
        return $respuesta;
    }

    public function obtenerTiposSector()
    {
        $this->db->select('*')->from('tipos_sector');
        $sector = $this->db->get()->result_array();

        $respuesta = array(
            'respuesta' => $sector,
            'status' => REST_Controller::HTTP_OK
        );

        return $respuesta;
    }



    //Adicionales

    public function obtener_add($idformato, $idcliente)
    {
        $where =  array(
            'idformato' => $idformato,
            'idcliente' => $idcliente
        );

        $query = $this->db->select("*")->get_where('5_ii_clientes_add', $where);
        if ($query && $query->num_rows() >= 1) {
            $data = $query->row();
            $respuesta = array(
                'mensaje' => 'Registros cargado correctamente',
                $this->db->last_query(),
                'registro' => $data,
                'status' => 200,
            );
        } else {
            $respuesta = array(
                'mensaje' => 'Error al cargar registros',
                $this->db->last_query(),
                'status' => 400,
            );
        }
        return $respuesta;
    }

    public function obtener5_ii_add()
    {

        $idformato = $this->uri->segment(3);
        $where =  array('idformato' => $idformato, 'activo' => 1);
        $query = $this->db->select("*")->get_where('5_ii_clientes_add', $where);

        if ($query && $query->num_rows() >= 1) {
            $data = $query->result_array();
            //VAR---'registro' => $data, -- no cambiar
            $respuesta = array(
                'mensaje' => 'Registros cargado correctamente',
                'registro' => $data,
                $this->db->last_query(),
                'status' => 200,
            );
        } else {
            $data = 'NA';
            $respuesta = array(
                'mensaje' => 'Error al cargar registros',
                'registro' => $data,
                $this->db->last_query(),
                'status' => 200,
            );
        }
        return $respuesta;
    }

    public function agregar5_ii_add($datos)
    {
        $idformato = $datos['idformato'];
        $idcliente = $datos['idcliente'];
        $data = array(
            'idformato' => $datos['idformato'],
            'actividad' => $datos['actividad'],
            'declarante' => $datos['declarante'],
            'nombre_empresa' => $datos['nombre_empresa'],
            'rfc_empresa' => $datos['rfc_empresa'],
            'cliente_principal' => $datos['cliente_principal'],
            'razon_social' => $datos['razon_social'],
            'rfc_razon' => $datos['rfc_razon'],
            'sector_productivo' => $datos['sector_productivo'],
            'sector_productivo_esp' => $datos['sector_productivo_esp'],
            'monto_mensual' => $datos['monto_mensual'],
            'mexico_extranjero' => $datos['mexico_extranjero'],
            'entidad_pais' => $datos['entidad_pais'],
            'aclaraciones' => $datos['aclaraciones'],

            'activo' =>  1,

        );
        if ($idcliente > 0) {
            $this->db->where('idcliente', $idcliente);
            $this->db->update('5_ii_clientes_add', $data);
            $id = $idformato;
        } else {

            $this->db->insert('5_ii_clientes_add', $data);
            $id = $this->db->insert_id();
        }

        if ($this->db->trans_status() === false) {
            $this->db->trans_rollback();
            $respuesta = array(
                'mensaje' => 'Error en inserción.',
                'error' => $this->db->error(),
                'status' => 409,
            );
        } else {
            $this->db->trans_commit();
            $respuesta = array(
                'mensaje' => 'Inserción correcta',
                'status' => 200,
            );
        }
        return $respuesta;
    }

    public function bajaCliente($datos)
    {
        $idcliente = $datos['idcliente'];

        $data = array(
            'activo' => 0,
        );
        if ($idcliente > 0) {

            $this->db->where('idcliente', $idcliente);
            $this->db->update('5_ii_clientes_add', $data);
            //   $id = $idformato;
        }

        if ($this->db->trans_status() === false) {
            $this->db->trans_rollback();
            $respuesta = array(
                'mensaje' => 'Error en inserción.',
                'error' => $this->db->error(),
                'status' => 409,
            );
        } else {
            $this->db->trans_commit();
            $respuesta = array(
                'mensaje' => 'Inserción correcta',
                'status' => 200,
            );
        }
        return $respuesta;
    }
  
}
