<?php

class Datos6_model extends CI_Model
{
    public function __construct()
    {
        parent::__construct();
        $this->load->database();
    }

//  I. DECLARACIÓN DE SITUACIÓN PATRIMONIAL INICIAL
//DATOS-6. 

    public function agregar6($datos)
    {
        $idformato = $datos['idformato'];
        $data = array(
            
            'nombre' => $datos['nombre'],
            'primer_apellido' =>  $datos['primer_apellido'],
            'segundo_apellido' =>  $datos['segundo_apellido'],
            'fecha_nacimiento' =>  $datos['fecha_nacimiento'],
            'rfc' =>  $datos['rfc'],
            'relacion_declarante' =>  $datos['relacion_declarante'],
            'ciudadano_extranjero' =>  $datos['ciudadano_extranjero'],
            'curp' =>  $datos['curp'],
            'dependiente_economico' =>  $datos['dependiente_economico'],
            'habita_domicilio' =>  $datos['habita_domicilio'],
            'lugar_residencia' =>  $datos['lugar_residencia'],
            'calle' =>  $datos['calle'],
            'numero_ext' =>  $datos['numero_ext'],
            'numero_int' =>  $datos['numero_int'],
            'localidad' =>  $datos['localidad'],
            'codigo_postal' =>  $datos['codigo_postal'],
            'municipio_estado' =>  $datos['municipio_estado'],
            'entidad_pais' =>  $datos['entidad_pais'],
            'mexico_extranjero' =>  $datos['mexico_extranjero'],

            //PUBLICO
            'actividad_laboral' =>  $datos['actividad_laboral'],
            'actividad_laboral_esp' =>  $datos['actividad_laboral_esp'],
            'orden_gobierno' =>  $datos['orden_gobierno'],
            'ambito_publico' =>  $datos['ambito_publico'],
            'ente_publico' =>  $datos['ente_publico'],
            'area_adscripcion' =>  $datos['area_adscripcion'],
            'cargo_publico' =>  $datos['cargo_publico'],
            'funcion_principal' =>  $datos['funcion_principal'],
            'salario_publico' =>  $datos['salario_publico'],
            'salario_moneda' =>  $datos['salario_moneda'],
            'fechaingreso_publico' =>  $datos['fechaingreso_publico'],

            //PRIVADO
            'nombre_empresa' =>  $datos['nombre_empresa'],
            'cargo_privado' =>  $datos['cargo_privado'],
            'rfc_privado' =>  $datos['rfc_privado'],
            'fechaingreso_privado' =>  $datos['fechaingreso_privado'],
            'sector' =>  $datos['sector'],
            'sector_esp' =>  $datos['sector_esp'],
            'salario_privado' =>  $datos['salario_privado'],
            'proveedor_contratista' =>  $datos['proveedor_contratista'],
         
            'aclaraciones' => $datos['aclaraciones'],
            'ninguno' => $datos['ninguno'],
            'progreso' => 5,
        );

        // $porcentaje = array(
        //     'porcentaje' => 30,
        // );

        if ($idformato > 0) {
            $this->db->where('idformato', $idformato);
            $this->db->update('6_datos_pareja', $data);
            $id = $idformato;

            // if ($datos['progreso'] < 35) {
            //     $this->db->where('idformato', $idformato);
            //     $this->db->update('progreso', $porcentaje);
            // }
        } else {
            $this->db->insert('6_datos_pareja', $data);
            $id = $this->db->insert_id();
        }

        if ($this->db->trans_status() === false) {
            $this->db->trans_rollback();
            $respuesta = array(
                'mensaje' => 'Error en inserción.',
                'error' => $this->db->error(),
                'status' => 409,
            );
        } else {
            $this->db->trans_commit();
            $respuesta = array(
                'mensaje' => 'Inserción correcta',
                'status' => 200,
            );
        }
        return $respuesta;
    }


    public function obtener6()
    {
        $idformato = $this->uri->segment(3);
        $where =  array('idformato' => $idformato);
        $query = $this->db->select("*")->get_where('6_datos_pareja', $where);

        if ($query && $query->num_rows() >= 1) {
            $data = $query->row();
            //VAR---'registro' => $data, -- no cambiar
            $respuesta = array(
                'mensaje' => 'Registros cargado correctamente',
                'registro' => $data,
                'status' => 200,
            );
        } else {
            $respuesta = array(
                'mensaje' => 'Error al cargar registros',
                 $this->db->last_query(),
                'status' => 400,
            );
        }
        return $respuesta;
    }


    //  II.- DECLARACIÓN DE INTERESES
    //DATOS-6

    public function agregar6_ii($datos)
    {
        $idformato = $datos['idformato'];
        $data = array(
            'tipo_beneficio' => $datos['tipo_beneficio'],
            'tipo_beneficio_esp' => $datos['tipo_beneficio_esp'],
            'beneficiario' => $datos['beneficiario'],
            'otorgante' => $datos['otorgante'],
            'nombre_otorgante' => $datos['nombre_otorgante'],
            'rfc' => $datos['rfc'],
            'forma_recepcion' => $datos['forma_recepcion'],
            'beneficio' => $datos['beneficio'],
            'monto_mensual' => $datos['monto_mensual'],
            'tipo_moneda' => $datos['tipo_moneda'],
            'sector_productivo' => $datos['sector_productivo'],
            'sector_productivo_esp' => $datos['sector_productivo_esp'],

            'ninguno' => $datos['ninguno'],
            'aclaraciones' => $datos['aclaraciones'],

            'progreso' => 4,
        );

        if ($idformato > 0) {
            $this->db->where('idformato', $idformato);
            $this->db->update('6_ii_beneficios', $data);
            $id = $idformato;
        } else {
            $this->db->insert('6_ii_beneficios', $data);
            $id = $this->db->insert_id();
        }

        if ($this->db->trans_status() === false) {
            $this->db->trans_rollback();
            $respuesta = array(
                'mensaje' => 'Error en inserción.',
                'error' => $this->db->error(),
                'status' => 409,
            );
        } else {
            $this->db->trans_commit();
            $respuesta = array(
                'mensaje' => 'Inserción correcta',
                'status' => 200,
            );
        }
        return $respuesta;
    }


    public function obtener6_ii()
    {
        $idformato = $this->uri->segment(3);
        $where =  array('idformato' => $idformato);
        $query = $this->db->select("*")->get_where('6_ii_beneficios', $where);

        if ($query && $query->num_rows() >= 1) {
            $data = $query->row();
            //VAR---'registro' => $data, -- no cambiar
            $respuesta = array(
                'mensaje' => 'Registros cargado correctamente',
                'registro' => $data,
                'status' => 200,
            );
        } else {
            $respuesta = array(
                'mensaje' => 'Error al cargar registros',
                $this->db->last_query(),
                'status' => 400,
            );
        }
        return $respuesta;
    }

    public function obtenerTiposSector()
    {
        $this->db->select('*')->from('tipos_sector');
        $sector = $this->db->get()->result_array();

        $respuesta = array(
            'respuesta' => $sector,
            'status' => REST_Controller::HTTP_OK
        );

        return $respuesta;
    }


    //Adicionales

    public function obtener_add($idformato, $idbeneficio)
    {
        $where =  array(
            'idformato' => $idformato,
            'idbeneficio' => $idbeneficio
        );

        $query = $this->db->select("*")->get_where('6_ii_beneficios_add', $where);
        if ($query && $query->num_rows() >= 1) {
            $data = $query->row();
            $respuesta = array(
                'mensaje' => 'Registros cargado correctamente',
                $this->db->last_query(),
                'registro' => $data,
                'status' => 200,
            );
        } else {
            $respuesta = array(
                'mensaje' => 'Error al cargar registros',
                $this->db->last_query(),
                'status' => 400,
            );
        }
        return $respuesta;
    }

    public function obtener6_ii_add()
    {

        $idformato = $this->uri->segment(3);
        $where =  array('idformato' => $idformato, 'activo' => 1);
        $query = $this->db->select("*")->get_where('6_ii_beneficios_add', $where);

        if ($query && $query->num_rows() >= 1) {
            $data = $query->result_array();
            //VAR---'registro' => $data, -- no cambiar
            $respuesta = array(
                'mensaje' => 'Registros cargado correctamente',
                'registro' => $data,
                $this->db->last_query(),
                'status' => 200,
            );
        } else {
            $data = 'NA';
            $respuesta = array(
                'mensaje' => 'Error al cargar registros',
                'registro' => $data,
                $this->db->last_query(),
                'status' => 200,
            );
        }
        return $respuesta;
    }

    public function agregar6_ii_add($datos)
    {
        $idformato = $datos['idformato'];
        $idbeneficio = $datos['idbeneficio'];
        $data = array(
            'idformato' => $datos['idformato'],
            'tipo_beneficio' => $datos['tipo_beneficio'],
            'tipo_beneficio_esp' => $datos['tipo_beneficio_esp'],
            'beneficiario' => $datos['beneficiario'],
            'otorgante' => $datos['otorgante'],
            'nombre_otorgante' => $datos['nombre_otorgante'],
            'rfc' => $datos['rfc'],
            'forma_recepcion' => $datos['forma_recepcion'],
            'beneficio' => $datos['beneficio'],
            'monto_mensual' => $datos['monto_mensual'],
            'tipo_moneda' => $datos['tipo_moneda'],
            'sector_productivo' => $datos['sector_productivo'],
            'sector_productivo_esp' => $datos['sector_productivo_esp'],
            'aclaraciones' => $datos['aclaraciones'],

            'activo' =>  1,

        );
        if ($idbeneficio > 0) {
            $this->db->where('idbeneficio', $idbeneficio);
            $this->db->update('6_ii_beneficios_add', $data);
            $id = $idformato;
        } else {

            $this->db->insert('6_ii_beneficios_add', $data);
            $id = $this->db->insert_id();
        }

        if ($this->db->trans_status() === false) {
            $this->db->trans_rollback();
            $respuesta = array(
                'mensaje' => 'Error en inserción.',
                'error' => $this->db->error(),
                'status' => 409,
            );
        } else {
            $this->db->trans_commit();
            $respuesta = array(
                'mensaje' => 'Inserción correcta',
                'status' => 200,
            );
        }
        return $respuesta;
    }

    public function bajaBeneficio($datos)
    {
        $idbeneficio = $datos['idbeneficio'];

        $data = array(
            'activo' => 0,
        );
        if ($idbeneficio > 0) {

            $this->db->where('idbeneficio', $idbeneficio);
            $this->db->update('6_ii_beneficios_add', $data);
            //   $id = $idformato;
        }

        if ($this->db->trans_status() === false) {
            $this->db->trans_rollback();
            $respuesta = array(
                'mensaje' => 'Error en inserción.',
                'error' => $this->db->error(),
                'status' => 409,
            );
        } else {
            $this->db->trans_commit();
            $respuesta = array(
                'mensaje' => 'Inserción correcta',
                'status' => 200,
            );
        }
        return $respuesta;
    }
}
