<?php

class Datos7_model extends CI_Model
{
    public function __construct()
    {
        parent::__construct();
        $this->load->database();
    }

//  I. DECLARACIÓN DE SITUACIÓN PATRIMONIAL INICIAL
//DATOS-7. 

    public function agregar7($datos)
    {
        $idformato = $datos['idformato'];
        $data = array(
            
            'nombre' => $datos['nombre'],
            'primer_apellido' =>  $datos['primer_apellido'],
            'segundo_apellido' =>  $datos['segundo_apellido'],
            'fecha_nacimiento' =>  $datos['fecha_nacimiento'],
            'rfc' =>  $datos['rfc'],
            'relacion_declarante' =>  $datos['relacion_declarante'],
            'relacion_declarante_esp' =>  $datos['relacion_declarante_esp'],
            'ciudadano_extranjero' =>  $datos['ciudadano_extranjero'],
            'curp' =>  $datos['curp'],
            'habita_domicilio' =>  $datos['habita_domicilio'],
            'lugar_residencia' =>  $datos['lugar_residencia'],
            'calle' =>  $datos['calle'],
            'numero_ext' =>  $datos['numero_ext'],
            'numero_int' =>  $datos['numero_int'],
            'localidad' =>  $datos['localidad'],
            'codigo_postal' =>  $datos['codigo_postal'],
            'municipio_estado' =>  $datos['municipio_estado'],
            'entidad_pais' =>  $datos['entidad_pais'],
            'mexico_extranjero' =>  $datos['mexico_extranjero'],

            //PUBLICO
            'actividad_laboral' =>  $datos['actividad_laboral'],
            'actividad_laboral_esp' =>  $datos['actividad_laboral_esp'],
            'orden_gobierno' =>  $datos['orden_gobierno'],
            'ambito_publico' =>  $datos['ambito_publico'],
            'ente_publico' =>  $datos['ente_publico'],
            'area_adscripcion' =>  $datos['area_adscripcion'],
            'cargo_publico' =>  $datos['cargo_publico'],
            'funcion_principal' =>  $datos['funcion_principal'],
            'salario_publico' =>  $datos['salario_publico'],
            'salario_moneda' =>  $datos['salario_moneda'],
            'fechaingreso_publico' =>  $datos['fechaingreso_publico'],

            //PRIVADO
            'nombre_empresa' =>  $datos['nombre_empresa'],
            'cargo_privado' =>  $datos['cargo_privado'],
            'rfc_privado' =>  $datos['rfc_privado'],
            'fechaingreso_privado' =>  $datos['fechaingreso_privado'],
            'sector' =>  $datos['sector'],
            'sector_esp' =>  $datos['sector_esp'],
            'salario_privado' =>  $datos['salario_privado'],
            'proveedor_contratista' =>  $datos['proveedor_contratista'],
         
            'aclaraciones' => $datos['aclaraciones'],
            'ninguno' => $datos['ninguno'],
            'progreso' => 5,
        );

 

        if ($idformato > 0) {
            $this->db->where('idformato', $idformato);
            $this->db->update('7_datos_dependiente', $data);
            $id = $idformato;
        } else {
            
            $this->db->insert('7_datos_dependiente', $data);
            $id = $this->db->insert_id();
        }

        if ($this->db->trans_status() === false) {
            $this->db->trans_rollback();
            $respuesta = array(
                'mensaje' => 'Error en inserción.',
                'error' => $this->db->error(),
                'status' => 409,
            );
        } else {
            $this->db->trans_commit();
            $respuesta = array(
                'mensaje' => 'Inserción correcta',
                'status' => 200,
            );
        }
        return $respuesta;
    }




    public function agregar7_add($datos)
    {
        $idformato = $datos['idformato'];
        $iddependiente = $datos['iddependiente'];
        $dependiente = $datos['dependiente_economico'];
        $data = array(
            'idformato' => $datos['idformato'],
            'nombre' => $datos['nombre'],
            'primer_apellido' =>  $datos['primer_apellido'],
            'segundo_apellido' =>  $datos['segundo_apellido'],
            'fecha_nacimiento' =>  $datos['fecha_nacimiento'],
            'rfc' =>  $datos['rfc'],
            'relacion_declarante' =>  $datos['relacion_declarante'],
            'relacion_declarante_esp' =>  $datos['relacion_declarante_esp'],
            'ciudadano_extranjero' =>  $datos['ciudadano_extranjero'],
            'curp' =>  $datos['curp'],
            'habita_domicilio' =>  $datos['habita_domicilio'],
            'lugar_residencia' =>  $datos['lugar_residencia'],
            'calle' =>  $datos['calle'],
            'numero_ext' =>  $datos['numero_ext'],
            'numero_int' =>  $datos['numero_int'],
            'localidad' =>  $datos['localidad'],
            'codigo_postal' =>  $datos['codigo_postal'],
            'municipio_estado' =>  $datos['municipio_estado'],
            'entidad_pais' =>  $datos['entidad_pais'],
            'mexico_extranjero' =>  $datos['mexico_extranjero'],
            'actividad_laboral' =>  $datos['actividad_laboral'],
            'actividad_laboral_esp' =>  $datos['actividad_laboral_esp'],
            'orden_gobierno' =>  $datos['orden_gobierno'],
            'ambito_publico' =>  $datos['ambito_publico'],
            'ente_publico' =>  $datos['ente_publico'],
            'area_adscripcion' =>  $datos['area_adscripcion'],
            'cargo_publico' =>  $datos['cargo_publico'],
            'funcion_principal' =>  $datos['funcion_principal'],
            'salario_publico' =>  $datos['salario_publico'],
            'salario_moneda' =>  $datos['salario_moneda'],
            'fechaingreso_publico' =>  $datos['fechaingreso_publico'],
            'nombre_empresa' =>  $datos['nombre_empresa'],
            'cargo_privado' =>  $datos['cargo_privado'],
            'rfc_privado' =>  $datos['rfc_privado'],
            'fechaingreso_privado' =>  $datos['fechaingreso_privado'],
            'sector' =>  $datos['sector'],
            'sector_esp' =>  $datos['sector_esp'],
            'salario_privado' =>  $datos['salario_privado'],
            'proveedor_contratista' =>  $datos['proveedor_contratista'],
            'aclaraciones' => $datos['aclaraciones'],
            'activo' => 1,

        );


        if ($iddependiente > 0) {
            //  if($dependiente==1){
            //      $this->db->insert('7_datos_dependientes_add', $data2);
            //  }
            $this->db->where('iddependiente', $iddependiente);
            $this->db->update('7_datos_dependientes_add', $data);
            $id = $idformato;
        } 
         else {

             $this->db->insert('7_datos_dependientes_add', $data);
             $id = $this->db->insert_id();
         }

        if ($this->db->trans_status() === false) {
            $this->db->trans_rollback();
            $respuesta = array(
                'mensaje' => 'Error en inserción.',
                'error' => $this->db->error(),
                'status' => 409,
            );
        } else {
            $this->db->trans_commit();
            $respuesta = array(
                'mensaje' => 'Inserción correcta',
                'status' => 200,
            );
        }
        return $respuesta;
    }



    public function bajaDependiente($datos){
        $iddependiente = $datos['iddependiente'];

         $data = array(
            'activo' => 0,
         );
        if ($iddependiente > 0) {
           
            $this->db->where('iddependiente', $iddependiente);
            $this->db->update('7_datos_dependientes_add', $data);
         //   $id = $idformato;
        }

        if ($this->db->trans_status() === false) {
            $this->db->trans_rollback();
            $respuesta = array(
                'mensaje' => 'Error en inserción.',
                'error' => $this->db->error(),
                'status' => 409,
            );
        } else {
            $this->db->trans_commit();
            $respuesta = array(
                'mensaje' => 'Inserción correcta',
                'status' => 200,
            );
        }
        return $respuesta;
    }

    public function obtenerDependientes($idformato,$iddependiente){
       // $idformato = $datos['idformato'];
      //  $idformato = $this->uri->segment(3);
        //     $dependiente = $datos['dependiente_economico'];
        //----------------------------------------------------
     //   $iddependiente = $this->uri->segment(3);
        //$where =  array('iddependiente' => $iddependiente);
        //----------------------------------------------------
        $where =  array('idformato' => $idformato,
            'iddependiente' => $iddependiente
    );

        $query = $this->db->select("*")->get_where('7_datos_dependientes_add', $where);
        if ($query && $query->num_rows() >= 1) {
            $data = $query->row();
            $respuesta = array(
                'mensaje' => 'Registros cargado correctamente',
                $this->db->last_query(),
                'registro' => $data,
                'status' => 200,
            );
        } else {
            $respuesta = array(
                'mensaje' => 'Error al cargar registros',
                $this->db->last_query(),
                'status' => 400,
            );
        }
        return $respuesta;
    }

    public function obtener7()
    {

        $idformato = $this->uri->segment(3);
        $where =  array('idformato' => $idformato);
        $query = $this->db->select("*")->get_where('7_datos_dependiente', $where);

        if ($query && $query->num_rows() >= 1) {
            $data = $query->row();
            //VAR---'registro' => $data, -- no cambiar
            $respuesta = array(
                'mensaje' => 'Registros cargado correctamente',
                'registro' => $data,
                'status' => 200,
            );
        } else {
            $respuesta = array(
                'mensaje' => 'Error al cargar registros',
                 $this->db->last_query(),
                'status' => 400,
            );
        }
        return $respuesta;
    }

    public function obtener7_add()
    {

        $idformato = $this->uri->segment(3);
        $where =  array('idformato' => $idformato, 'activo' => 1);
        $query = $this->db->select("*")->get_where('7_datos_dependientes_add', $where);

        if ($query && $query->num_rows() >= 1) {
            $data = $query->result_array();
            //VAR---'registro' => $data, -- no cambiar
            $respuesta = array(
                'mensaje' => 'Registros cargado correctamente',
                'registro' => $data,
                $this->db->last_query(),
                'status' => 200,
            );
        } else {
            $data = 'NA';
            $respuesta = array(
                'mensaje' => 'Error al cargar registros',
                'registro' => $data,
                $this->db->last_query(),
                'status' => 200,
            );
        }
        return $respuesta;
    }


    //  II.- DECLARACIÓN DE INTERESES
    //DATOS-7

    public function agregar7_ii($datos)
    {
        $idformato = $datos['idformato'];
        $data = array(
            'participacion' => $datos['participacion'],
            'tipo_fideicomiso' => $datos['tipo_fideicomiso'],
            'tipo_participacion' => $datos['tipo_participacion'],
            'rfc_fideicomiso' => $datos['rfc_fideicomiso'],
            'fideicomitente' => $datos['fideicomitente'],
            'nombre_fideicomitente' => $datos['nombre_fideicomitente'],
            'rfc_fideicomitente' => $datos['rfc_fideicomitente'],
            'nombre_fiduciario' => $datos['nombre_fiduciario'],
            'rfc_fiduciario' => $datos['rfc_fiduciario'],
            'fideicomisario' => $datos['fideicomisario'],
            'nombre_fideicomisario' => $datos['nombre_fideicomisario'],
            'rfc_fideicomisario' => $datos['rfc_fideicomisario'],
            'mexico_extranjero' => $datos['mexico_extranjero'],
         
            'sector_productivo' => $datos['sector_productivo'],
            'sector_productivo_esp' => $datos['sector_productivo_esp'],

            'ninguno' => $datos['ninguno'],
            'aclaraciones' => $datos['aclaraciones'],

            'progreso' => 1,
        );

        if ($idformato > 0) {
            $this->db->where('idformato', $idformato);
            $this->db->update('7_ii_fideicomisos', $data);
            $id = $idformato;
        } else {
            $this->db->insert('7_ii_fideicomisos', $data);
            $id = $this->db->insert_id();
        }

        if ($this->db->trans_status() === false) {
            $this->db->trans_rollback();
            $respuesta = array(
                'mensaje' => 'Error en inserción.',
                'error' => $this->db->error(),
                'status' => 409,
            );
        } else {
            $this->db->trans_commit();
            $respuesta = array(
                'mensaje' => 'Inserción correcta',
                'status' => 200,
            );
        }
        return $respuesta;
    }


    public function obtener7_ii()
    {
        $idformato = $this->uri->segment(3);
        $where =  array('idformato' => $idformato);
        $query = $this->db->select("*")->get_where('7_ii_fideicomisos', $where);

        if ($query && $query->num_rows() >= 1) {
            $data = $query->row();
            //VAR---'registro' => $data, -- no cambiar
            $respuesta = array(
                'mensaje' => 'Registros cargado correctamente',
                'registro' => $data,
                'status' => 200,
            );
        } else {
            $respuesta = array(
                'mensaje' => 'Error al cargar registros',
                $this->db->last_query(),
                'status' => 400,
            );
        }
        return $respuesta;
    }

    public function obtenerTiposSector()
    {
        $this->db->select('*')->from('tipos_sector');
        $sector = $this->db->get()->result_array();

        $respuesta = array(
            'respuesta' => $sector,
            'status' => REST_Controller::HTTP_OK
        );

        return $respuesta;
    }


    //Adicionales

    public function obtener_add_ii($idformato, $idfideicomiso)
    {
        $where =  array(
            'idformato' => $idformato,
            'idfideicomiso' => $idfideicomiso
        );

        $query = $this->db->select("*")->get_where('7_ii_fideicomisos_add', $where);
        if ($query && $query->num_rows() >= 1) {
            $data = $query->row();
            $respuesta = array(
                'mensaje' => 'Registros cargado correctamente',
                $this->db->last_query(),
                'registro' => $data,
                'status' => 200,
            );
        } else {
            $respuesta = array(
                'mensaje' => 'Error al cargar registros',
                $this->db->last_query(),
                'status' => 400,
            );
        }
        return $respuesta;
    }

    public function obtener7_ii_add()
    {

        $idformato = $this->uri->segment(3);
        $where =  array('idformato' => $idformato, 'activo' => 1);
        $query = $this->db->select("*")->get_where('7_ii_fideicomisos_add', $where);

        if ($query && $query->num_rows() >= 1) {
            $data = $query->result_array();
            //VAR---'registro' => $data, -- no cambiar
            $respuesta = array(
                'mensaje' => 'Registros cargado correctamente',
                'registro' => $data,
                $this->db->last_query(),
                'status' => 200,
            );
        } else {
            $data = 'NA';
            $respuesta = array(
                'mensaje' => 'Error al cargar registros',
                'registro' => $data,
                $this->db->last_query(),
                'status' => 200,
            );
        }
        return $respuesta;
    }

    public function agregar7_ii_add($datos)
    {
        $idformato = $datos['idformato'];
        $idfideicomiso = $datos['idfideicomiso'];
        $data = array(
            'idformato' => $datos['idformato'],
            'participacion' => $datos['participacion'],
            'tipo_fideicomiso' => $datos['tipo_fideicomiso'],
            'tipo_participacion' => $datos['tipo_participacion'],
            'rfc_fideicomiso' => $datos['rfc_fideicomiso'],
            'fideicomitente' => $datos['fideicomitente'],
            'nombre_fideicomitente' => $datos['nombre_fideicomitente'],
            'rfc_fideicomitente' => $datos['rfc_fideicomitente'],
            'nombre_fiduciario' => $datos['nombre_fiduciario'],
            'rfc_fiduciario' => $datos['rfc_fiduciario'],
            'fideicomisario' => $datos['fideicomisario'],
            'nombre_fideicomisario' => $datos['nombre_fideicomisario'],
            'rfc_fideicomisario' => $datos['rfc_fideicomisario'],
            'mexico_extranjero' => $datos['mexico_extranjero'],
            'sector_productivo' => $datos['sector_productivo'],
            'sector_productivo_esp' => $datos['sector_productivo_esp'],

            'aclaraciones' => $datos['aclaraciones'],

            'activo' =>  1,

        );
        if ($idfideicomiso > 0) {
            $this->db->where('idfideicomiso', $idfideicomiso);
            $this->db->update('7_ii_fideicomisos_add', $data);
            $id = $idformato;
        } else {

            $this->db->insert('7_ii_fideicomisos_add', $data);
            $id = $this->db->insert_id();
        }

        if ($this->db->trans_status() === false) {
            $this->db->trans_rollback();
            $respuesta = array(
                'mensaje' => 'Error en inserción.',
                'error' => $this->db->error(),
                'status' => 409,
            );
        } else {
            $this->db->trans_commit();
            $respuesta = array(
                'mensaje' => 'Inserción correcta',
                'status' => 200,
            );
        }
        return $respuesta;
    }

    public function bajaFideicomiso($datos)
    {
        $idfideicomiso = $datos['idfideicomiso'];

        $data = array(
            'activo' => 0,
        );
        if ($idfideicomiso > 0) {

            $this->db->where('idfideicomiso', $idfideicomiso);
            $this->db->update('7_ii_fideicomisos_add', $data);
            //   $id = $idformato;
        }

        if ($this->db->trans_status() === false) {
            $this->db->trans_rollback();
            $respuesta = array(
                'mensaje' => 'Error en inserción.',
                'error' => $this->db->error(),
                'status' => 409,
            );
        } else {
            $this->db->trans_commit();
            $respuesta = array(
                'mensaje' => 'Inserción correcta',
                'status' => 200,
            );
        }
        return $respuesta;
    }
}
