<?php

class Datos9_model extends CI_Model
{
    public function __construct()
    {
        parent::__construct();
        $this->load->database();
    }

//  I. DECLARACIÓN DE SITUACIÓN PATRIMONIAL INICIAL
//DATOS-9.  BIENES INMUEBLES (ENTRE EL 1 DE ENERO 

    public function agregar9($datos)
    {
        $idformato = $datos['idformato'];
        $data = array(
            
            'tipo_inmueble' => $datos['tipo_inmueble'],
            'tipo_inmueble_esp' => $datos['tipo_inmueble_esp'],
            'titular_inmueble' => $datos['titular_inmueble'],
            'porcentaje_propiedad' => $datos['porcentaje_propiedad'],
            'superficie_terreno' => $datos['superficie_terreno'],
            'superficie_construccion' => $datos['superficie_construccion'],
            'tercero' => $datos['tercero'],
            'nombre_tercero' => $datos['nombre_tercero'],
            'rfc_tercero' => $datos['rfc_tercero'],
            'forma_adquisicion' => $datos['forma_adquisicion'],
            'forma_pago' => $datos['forma_pago'],
            'transmisor' => $datos['transmisor'],
            'nombre_transmisor' => $datos['nombre_transmisor'],
            'rfc_transmisor' => $datos['rfc_transmisor'],
            'relacion_transmisor' => $datos['relacion_transmisor'],
            'relacion_transmisor_esp' => $datos['relacion_transmisor_esp'],
            'valor_adquisicion' => $datos['valor_adquisicion'],
            'tipo_moneda' => $datos['tipo_moneda'],
            'fecha_adquisicion' => $datos['fecha_adquisicion'],
            'datos_registro' => $datos['datos_registro'],
            'adquisicion_conforme' => $datos['adquisicion_conforme'],

            //Domicilio
            'calle' =>  $datos['calle'],
            'numero_ext' =>  $datos['numero_ext'],
            'numero_int' =>  $datos['numero_int'],
            'localidad' =>  $datos['localidad'],
            'codigo_postal' =>  $datos['codigo_postal'],
            'municipio_estado' =>  $datos['municipio_estado'],
            'entidad_pais' =>  $datos['entidad_pais'],
            'mexico_extranjero' =>  $datos['mexico_extranjero'],

            'motivo_baja' => $datos['motivo_baja'],
            'motivo_baja_esp' => $datos['motivo_baja_esp'],
            'ninguno' => $datos['ninguno'], 
            'aclaraciones' => $datos['aclaraciones'],
            'progreso' => 5,

            
        );

        if ($idformato > 0) {
            $this->db->where('idformato', $idformato);
            $this->db->update('9_bienes_inmuebles', $data);
            $id = $idformato;
        } else {
            $this->db->insert('9_bienes_inmuebles', $data);
            $id = $this->db->insert_id();
        }

        if ($this->db->trans_status() === false) {
            $this->db->trans_rollback();
            $respuesta = array(
                'mensaje' => 'Error en inserción.',
                'error' => $this->db->error(),
                'status' => 409,
            );
        } else {
            $this->db->trans_commit();
            $respuesta = array(
                'mensaje' => 'Inserción correcta',
                'status' => 200,
            );
        }
        return $respuesta;
    }


    public function obtener9()
    {
        $idformato = $this->uri->segment(3);
        $where =  array('idformato' => $idformato);
        $query = $this->db->select("*")->get_where('9_bienes_inmuebles', $where);

        if ($query && $query->num_rows() >= 1) {
            $data = $query->row();
            $respuesta = array(
                'mensaje' => 'Registros cargado correctamente',
                'registro' => $data,
                'status' => 200,
            );
        } else {
            $respuesta = array(
                'mensaje' => 'Error al cargar registros',
                 $this->db->last_query(),
                'status' => 400,
            );
        }
        return $respuesta;
    }

    public function obtenerTiposDeclarante()
    {
        $this->db->select('*')->from('tipos_declarante');
        $publicidad = $this->db->get()->result_array();

        $respuesta = array(
            'respuesta' => $publicidad,
            'status' => REST_Controller::HTTP_OK
        );

        return $respuesta;
    }

    public function obtenerTiposRelacion()
    {
        $this->db->select('*')->from('tipos_relacion');
        $relacion = $this->db->get()->result_array();

        $respuesta = array(
            'respuesta' => $relacion,
            'status' => REST_Controller::HTTP_OK
        );

        return $respuesta;
    }

    public function obtener_add($idformato, $idinmueble)
    {
        $where =  array(
            'idformato' => $idformato,
            'idinmueble' => $idinmueble
        );

        $query = $this->db->select("*")->get_where('9_bienes_inmuebles_add', $where);
        if ($query && $query->num_rows() >= 1) {
            $data = $query->row();
            $respuesta = array(
                'mensaje' => 'Registros cargado correctamente',
                $this->db->last_query(),
                'registro' => $data,
                'status' => 200,
            );
        } else {
            $respuesta = array(
                'mensaje' => 'Error al cargar registros',
                $this->db->last_query(),
                'status' => 400,
            );
        }
        return $respuesta;
    }

    public function obtener9_add()
    {

        $idformato = $this->uri->segment(3);
        $where =  array('idformato' => $idformato, 'activo' => 1);
        $query = $this->db->select("*")->get_where('9_bienes_inmuebles_add', $where);

        if ($query && $query->num_rows() >= 1) {
            $data = $query->result_array();
            //VAR---'registro' => $data, -- no cambiar
            $respuesta = array(
                'mensaje' => 'Registros cargado correctamente',
                'registro' => $data,
                $this->db->last_query(),
                'status' => 200,
            );
        } else {
            $data = 'NA';
            $respuesta = array(
                'mensaje' => 'Error al cargar registros',
                'registro' => $data,
                $this->db->last_query(),
                'status' => 200,
            );
        }
        return $respuesta;
    }

    public function agregar9_add($datos)
    {
        $idformato = $datos['idformato'];
        $idinmueble = $datos['idinmueble'];
        $data = array(
            'idformato' => $datos['idformato'],
            'tipo_inmueble' => $datos['tipo_inmueble'],
            'tipo_inmueble_esp' => $datos['tipo_inmueble_esp'],
            'titular_inmueble' => $datos['titular_inmueble'],
            'porcentaje_propiedad' => $datos['porcentaje_propiedad'],
            'superficie_terreno' => $datos['superficie_terreno'],
            'superficie_construccion' => $datos['superficie_construccion'],
            'tercero' => $datos['tercero'],
            'nombre_tercero' => $datos['nombre_tercero'],
            'rfc_tercero' => $datos['rfc_tercero'],
            'forma_adquisicion' => $datos['forma_adquisicion'],
            'forma_pago' => $datos['forma_pago'],
            'transmisor' => $datos['transmisor'],
            'nombre_transmisor' => $datos['nombre_transmisor'],
            'rfc_transmisor' => $datos['rfc_transmisor'],
            'relacion_transmisor' => $datos['relacion_transmisor'],
            'relacion_transmisor_esp' => $datos['relacion_transmisor_esp'],
            'valor_adquisicion' => $datos['valor_adquisicion'],
            'tipo_moneda' => $datos['tipo_moneda'],
            'fecha_adquisicion' => $datos['fecha_adquisicion'],
            'datos_registro' => $datos['datos_registro'],
            'adquisicion_conforme' => $datos['adquisicion_conforme'],
            'calle' =>  $datos['calle'],
            'numero_ext' =>  $datos['numero_ext'],
            'numero_int' =>  $datos['numero_int'],
            'localidad' =>  $datos['localidad'],
            'codigo_postal' =>  $datos['codigo_postal'],
            'municipio_estado' =>  $datos['municipio_estado'],
            'entidad_pais' =>  $datos['entidad_pais'],
            'mexico_extranjero' =>  $datos['mexico_extranjero'],
            'motivo_baja' => $datos['motivo_baja'],
            'motivo_baja_esp' => $datos['motivo_baja_esp'],
            'ninguno' => $datos['ninguno'],
            'aclaraciones' => $datos['aclaraciones'],
            'activo' =>  1,

        );


        if ($idinmueble > 0) {
            $this->db->where('idinmueble', $idinmueble);
            $this->db->update('9_bienes_inmuebles_add', $data);
            $id = $idformato;
        } else {

            $this->db->insert('9_bienes_inmuebles_add', $data);
            $id = $this->db->insert_id();
        }

        if ($this->db->trans_status() === false) {
            $this->db->trans_rollback();
            $respuesta = array(
                'mensaje' => 'Error en inserción.',
                'error' => $this->db->error(),
                'status' => 409,
            );
        } else {
            $this->db->trans_commit();
            $respuesta = array(
                'mensaje' => 'Inserción correcta',
                'status' => 200,
            );
        }
        return $respuesta;
    }

    public function bajaInmueble($datos)
    {
        $idinmueble = $datos['idinmueble'];

        $data = array(
            'activo' => 0,
        );
        if ($idinmueble > 0) {

            $this->db->where('idinmueble', $idinmueble);
            $this->db->update('9_bienes_inmuebles_add', $data);
            //   $id = $idformato;
        }

        if ($this->db->trans_status() === false) {
            $this->db->trans_rollback();
            $respuesta = array(
                'mensaje' => 'Error en inserción.',
                'error' => $this->db->error(),
                'status' => 409,
            );
        } else {
            $this->db->trans_commit();
            $respuesta = array(
                'mensaje' => 'Inserción correcta',
                'status' => 200,
            );
        }
        return $respuesta;
    }
}
